/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.common;

import io.micrometer.common.KeyValue;
import java.util.function.Predicate;

class ValidatedKeyValue<T>
implements KeyValue {
    private final String key;
    private final String value;

    ValidatedKeyValue(String key2, T value2, Predicate<? super T> validator) {
        this.key = key2;
        this.value = String.valueOf(this.assertValue(value2, validator));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    private T assertValue(T value2, Predicate<? super T> validator) {
        if (!validator.test(value2)) {
            throw new IllegalArgumentException("Argument [" + value2 + "] does not follow required format for key [" + this.key + "]");
        }
        return value2;
    }

    public String toString() {
        return "keyValue(" + this.key + "=" + this.value + ")";
    }
}

