/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartHandle;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class SmartBinder {
    private final Signature start;
    private final List<Signature> signatures = new ArrayList<Signature>();
    private final Binder binder;

    private SmartBinder(Signature start2, Binder binder) {
        this.start = start2;
        this.signatures.add(start2);
        this.binder = binder;
    }

    private SmartBinder(SmartBinder original, Signature next2, Binder binder) {
        this.start = original.start;
        this.signatures.add(0, next2);
        this.signatures.addAll(original.signatures);
        this.binder = binder;
    }

    public Signature signature() {
        return this.signatures.get(0);
    }

    public Signature baseSignature() {
        return this.signatures.get(this.signatures.size() - 1);
    }

    public Binder binder() {
        return this.binder;
    }

    public static SmartBinder from(Signature inbound) {
        return new SmartBinder(inbound, Binder.from(inbound.type()));
    }

    public static SmartBinder from(Class<?> retType, String[] names2, Class<?> ... types) {
        return SmartBinder.from(Signature.returning(retType).appendArgs(names2, types));
    }

    public static SmartBinder from(Class<?> retType, String name2, Class<?> type2) {
        return SmartBinder.from(Signature.returning(retType).appendArg(name2, type2));
    }

    public static SmartBinder from(MethodHandles.Lookup lookup, Signature inbound) {
        return new SmartBinder(inbound, Binder.from(lookup, inbound.type()));
    }

    public static SmartBinder from(MethodHandles.Lookup lookup, Class<?> retType, String[] names2, Class<?> ... types) {
        return SmartBinder.from(lookup, Signature.returning(retType).appendArgs(names2, types));
    }

    public static SmartBinder from(MethodHandles.Lookup lookup, Class<?> retType, String name2, Class<?> type2) {
        return SmartBinder.from(lookup, Signature.returning(retType).appendArg(name2, type2));
    }

    public SmartBinder fold(String newName, MethodHandle function) {
        return new SmartBinder(this, this.signature().prependArg(newName, (Class<?>)function.type().returnType()), this.binder.fold(function));
    }

    public SmartBinder fold(String newName, SmartHandle function) {
        if (Arrays.equals(this.signature().argNames(), function.signature().argNames())) {
            return this.fold(newName, function.handle());
        }
        return this.fold(newName, this.signature().changeReturn((Class<?>)function.signature().type().returnType()).permuteWith(function).handle());
    }

    public SmartBinder foldVoid(MethodHandle function) {
        return new SmartBinder(this, this.signature(), this.binder.foldVoid(function));
    }

    public SmartBinder foldVoid(SmartHandle function) {
        if (Arrays.equals(this.signature().argNames(), function.signature().argNames())) {
            return this.foldVoid(function.handle());
        }
        return this.foldVoid(this.signature().asFold(Void.TYPE).permuteWith(function).handle());
    }

    public SmartBinder foldStatic(String newName, MethodHandles.Lookup lookup, Class<?> target2, String method2) {
        Binder newBinder = this.binder.foldStatic(lookup, target2, method2);
        return new SmartBinder(this, this.signature().prependArg(newName, (Class<?>)newBinder.type().parameterType(0)), this.binder);
    }

    public SmartBinder foldStatic(String newName, Class<?> target2, String method2) {
        Binder newBinder = this.binder.foldStatic(target2, method2);
        return new SmartBinder(this, this.signature().prependArg(newName, (Class<?>)newBinder.type().parameterType(0)), newBinder);
    }

    public SmartBinder foldVirtual(String newName, MethodHandles.Lookup lookup, String method2) {
        Binder newBinder = this.binder.foldVirtual(lookup, method2);
        return new SmartBinder(this, this.signature().prependArg(newName, (Class<?>)newBinder.type().parameterType(0)), newBinder);
    }

    public SmartBinder foldVirtual(String newName, String method2) {
        Binder newBinder = this.binder.foldVirtual(method2);
        return new SmartBinder(this, this.signature().prependArg(newName, (Class<?>)newBinder.type().parameterType(0)), newBinder);
    }

    public SmartBinder permute(Signature target2) {
        return new SmartBinder(this, target2, this.binder.permute(this.signature().to(target2)));
    }

    public SmartBinder permute(String ... targetNames) {
        return this.permute(this.signature().permute(targetNames));
    }

    public SmartBinder exclude(String ... excludeNames) {
        return this.permute(this.signature().exclude(excludeNames));
    }

    public SmartBinder spread(String[] spreadNames, Class<?> ... spreadTypes) {
        return new SmartBinder(this, this.signature().spread(spreadNames, spreadTypes), this.binder.spread(spreadTypes));
    }

    public SmartBinder spread(String baseName, int count2) {
        return new SmartBinder(this, this.signature().spread(baseName, count2), this.binder.spread(count2));
    }

    public SmartBinder insert(int index2, String name2, Object value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, value2.getClass()), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, boolean value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, Boolean.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, byte value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, Byte.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, short value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, Short.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, char value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, Character.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, int value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, Integer.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, long value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, Long.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, float value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, Float.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, double value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, Double.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, Class<?> type2, Object value2) {
        return new SmartBinder(this, this.signature().insertArg(index2, name2, type2), this.binder.insert(index2, type2, value2));
    }

    public SmartBinder insert(int index2, String[] names2, Class<?>[] types, Object ... values2) {
        return new SmartBinder(this, this.signature().insertArgs(index2, names2, types), this.binder.insert(index2, types, values2));
    }

    public SmartBinder append(String name2, Object value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, value2.getClass()), this.binder.append(value2));
    }

    public SmartBinder append(String name2, boolean value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, Boolean.TYPE), this.binder.append(value2));
    }

    public SmartBinder append(String name2, byte value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, Byte.TYPE), this.binder.append(value2));
    }

    public SmartBinder append(String name2, short value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, Short.TYPE), this.binder.append(value2));
    }

    public SmartBinder append(String name2, char value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, Character.TYPE), this.binder.append(value2));
    }

    public SmartBinder append(String name2, int value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, Integer.TYPE), this.binder.append(value2));
    }

    public SmartBinder append(String name2, long value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, Long.TYPE), this.binder.append(value2));
    }

    public SmartBinder append(String name2, float value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, Float.TYPE), this.binder.append(value2));
    }

    public SmartBinder append(String name2, double value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, Double.TYPE), this.binder.append(value2));
    }

    public SmartBinder append(String name2, Class<?> type2, Object value2) {
        return new SmartBinder(this, this.signature().appendArg(name2, type2), this.binder.append(new Class[]{type2}, value2));
    }

    public SmartBinder append(String[] names2, Class<?>[] types, Object ... values2) {
        return new SmartBinder(this, this.signature().appendArgs(names2, types), this.binder.append(types, values2));
    }

    public SmartBinder prepend(String name2, Object value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, value2.getClass()), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, boolean value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, Boolean.TYPE), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, byte value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, Byte.TYPE), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, short value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, Short.TYPE), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, char value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, Character.TYPE), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, int value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, Integer.TYPE), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, long value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, Long.TYPE), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, float value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, Float.TYPE), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, double value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, Double.TYPE), this.binder.prepend(value2));
    }

    public SmartBinder prepend(String name2, Class<?> type2, Object value2) {
        return new SmartBinder(this, this.signature().prependArg(name2, type2), this.binder.prepend(type2, value2));
    }

    public SmartBinder prepend(String[] names2, Class<?>[] types, Object ... values2) {
        return new SmartBinder(this, this.signature().prependArgs(names2, types), this.binder.prepend(types, values2));
    }

    public SmartBinder drop(String name2) {
        int index2 = this.signature().argOffset(name2);
        return new SmartBinder(this, this.signature().dropArg(index2), this.binder.drop(index2));
    }

    public SmartBinder dropLast() {
        return this.dropLast(1);
    }

    public SmartBinder dropLast(int count2) {
        return new SmartBinder(this, this.signature().dropLast(count2), this.binder.dropLast(count2));
    }

    public SmartBinder dropFirst() {
        return this.dropFirst(1);
    }

    public SmartBinder dropFirst(int count2) {
        return new SmartBinder(this, this.signature().dropFirst(count2), this.binder.dropFirst(count2));
    }

    public SmartBinder collect(String outName, String namePattern) {
        int index2 = this.signature().argOffsets(namePattern);
        assert (index2 >= 0) : "no arguments matching " + namePattern + " found in signature " + this.signature();
        Signature newSignature = this.signature().collect(outName, namePattern);
        return new SmartBinder(this, newSignature, this.binder.collect(index2, this.signature().argCount() - (newSignature.argCount() - 1), Array.newInstance(this.signature().argType(index2), 0).getClass()));
    }

    public SmartBinder collect(String outName, String namePattern, MethodHandle collector) {
        int index2 = this.signature().argOffsets(namePattern);
        assert (index2 >= 0) : "no arguments matching " + namePattern + " found in signature " + this.signature();
        Signature newSignature = this.signature().collect(outName, namePattern);
        return new SmartBinder(this, newSignature, this.binder.collect(index2, this.signature().argCount() - (newSignature.argCount() - 1), Array.newInstance(this.signature().argType(index2), 0).getClass(), collector));
    }

    public SmartBinder cast(Signature target2) {
        return new SmartBinder(target2, this.binder.cast(target2.type()));
    }

    public SmartBinder cast(Class<?> returnType, Class<?> ... argTypes) {
        return new SmartBinder(this, new Signature(returnType, argTypes, this.signature().argNames()), this.binder.cast(returnType, argTypes));
    }

    public SmartBinder castVirtual(Class<?> returnType, Class<?> firstArg, Class<?> ... restArgs) {
        return new SmartBinder(this, new Signature(returnType, firstArg, restArgs, this.signature().argNames()), this.binder.castVirtual(returnType, firstArg, restArgs));
    }

    public SmartBinder castArg(String name2, Class<?> type2) {
        Signature newSig = this.signature().replaceArg(name2, name2, type2);
        return new SmartBinder(this, newSig, this.binder.cast(newSig.type()));
    }

    public SmartBinder castReturn(Class<?> type2) {
        return new SmartBinder(this, this.signature().changeReturn(type2), this.binder.cast(type2, this.binder.type().parameterArray()));
    }

    public SmartBinder filterReturn(MethodHandle filter2) {
        return new SmartBinder(this, this.signature().changeReturn((Class<?>)filter2.type().returnType()), this.binder.filterReturn(filter2));
    }

    public SmartBinder filterReturn(SmartHandle filter2) {
        return new SmartBinder(this, this.signature().changeReturn((Class<?>)filter2.signature().type().returnType()), this.binder.filterReturn(filter2.handle()));
    }

    public SmartHandle invokeVirtual(MethodHandles.Lookup lookup, String name2) throws NoSuchMethodException, IllegalAccessException {
        return new SmartHandle(this.start, this.binder.invokeVirtual(lookup, name2));
    }

    public SmartHandle invokeVirtualQuiet(MethodHandles.Lookup lookup, String name2) {
        return new SmartHandle(this.start, this.binder.invokeVirtualQuiet(lookup, name2));
    }

    public SmartHandle invokeStatic(MethodHandles.Lookup lookup, Class<?> target2, String name2) throws NoSuchMethodException, IllegalAccessException {
        return new SmartHandle(this.start, this.binder.invokeStatic(lookup, target2, name2));
    }

    public SmartHandle invokeStaticQuiet(MethodHandles.Lookup lookup, Class<?> target2, String name2) {
        return new SmartHandle(this.start, this.binder.invokeStaticQuiet(lookup, target2, name2));
    }

    public SmartHandle invoke(SmartHandle target2) {
        return new SmartHandle(this.start, this.binder.invoke(target2.handle()));
    }

    public SmartHandle invoke(MethodHandle target2) {
        return new SmartHandle(this.start, this.binder.invoke(target2));
    }

    public SmartHandle arrayGet() {
        return new SmartHandle(this.start, this.binder.arrayGet());
    }

    public SmartHandle arraySet() {
        return new SmartHandle(this.start, this.binder.arraySet());
    }

    public SmartHandle identity() {
        return new SmartHandle(this.start, this.binder.identity());
    }

    public SmartBinder printSignature() {
        return this.printSignature(System.out);
    }

    public SmartBinder printSignature(PrintStream ps) {
        ps.println(this.signature().toString());
        return this;
    }

    public SmartHandle invoker() {
        return new SmartHandle(this.start, this.binder.invoker());
    }

    public SmartBinder filter(String pattern, MethodHandle filter2) {
        String[] argNames = this.signature().argNames();
        Pattern pat = Pattern.compile(pattern);
        Binder newBinder = this.binder();
        Signature newSig = this.signature();
        for (int i2 = 0; i2 < argNames.length; ++i2) {
            if (!pat.matcher(argNames[i2]).matches()) continue;
            newBinder = newBinder.filter(i2, filter2);
            newSig = newSig.argType(i2, (Class<?>)filter2.type().returnType());
        }
        return new SmartBinder(newSig, newBinder);
    }

    public SmartBinder tryFinally(MethodHandle post) {
        return new SmartBinder(this, this.signature(), this.binder.tryFinally(post));
    }
}

