/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ArrayTypeAdapter<E>
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type2 = typeToken.getType();
            if (!(type2 instanceof GenericArrayType || type2 instanceof Class && ((Class)type2).isArray())) {
                return null;
            }
            Type componentType = $Gson$Types.getArrayComponentType(type2);
            TypeAdapter<?> componentTypeAdapter = gson.getAdapter(TypeToken.get(componentType));
            ArrayTypeAdapter arrayAdapter = new ArrayTypeAdapter(gson, componentTypeAdapter, $Gson$Types.getRawType(componentType));
            return arrayAdapter;
        }
    };
    private final Class<E> componentType;
    private final TypeAdapter<E> componentTypeAdapter;

    public ArrayTypeAdapter(Gson context, TypeAdapter<E> componentTypeAdapter, Class<E> componentType) {
        this.componentTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, componentTypeAdapter, componentType);
        this.componentType = componentType;
    }

    @Override
    public Object read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<E> list2 = new ArrayList<E>();
        in.beginArray();
        while (in.hasNext()) {
            E instance = this.componentTypeAdapter.read(in);
            list2.add(instance);
        }
        in.endArray();
        int size2 = list2.size();
        if (this.componentType.isPrimitive()) {
            Object array2 = Array.newInstance(this.componentType, size2);
            for (int i2 = 0; i2 < size2; ++i2) {
                Array.set(array2, i2, list2.get(i2));
            }
            return array2;
        }
        Object[] array3 = (Object[])Array.newInstance(this.componentType, size2);
        return list2.toArray(array3);
    }

    @Override
    public void write(JsonWriter out, Object array2) throws IOException {
        if (array2 == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        int length2 = Array.getLength(array2);
        for (int i2 = 0; i2 < length2; ++i2) {
            Object value2 = Array.get(array2, i2);
            this.componentTypeAdapter.write(out, value2);
        }
        out.endArray();
    }
}

