/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.ToNumberStrategy;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.NumberLimits;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.math.BigDecimal;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public Double readNumber(JsonReader in) throws IOException {
            return in.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        @Override
        public Number readNumber(JsonReader in) throws IOException {
            return new LazilyParsedNumber(in.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        @Override
        public Number readNumber(JsonReader in) throws IOException, JsonParseException {
            String value2 = in.nextString();
            if (value2.indexOf(46) >= 0) {
                return this.parseAsDouble(value2, in);
            }
            try {
                return Long.parseLong(value2);
            }
            catch (NumberFormatException e) {
                return this.parseAsDouble(value2, in);
            }
        }

        private Number parseAsDouble(String value2, JsonReader in) throws IOException {
            try {
                Double d = Double.valueOf(value2);
                if ((d.isInfinite() || d.isNaN()) && !in.isLenient()) {
                    throw new MalformedJsonException("JSON forbids NaN and infinities: " + d + "; at path " + in.getPreviousPath());
                }
                return d;
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Cannot parse " + value2 + "; at path " + in.getPreviousPath(), e);
            }
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public BigDecimal readNumber(JsonReader in) throws IOException {
            String value2 = in.nextString();
            try {
                return NumberLimits.parseBigDecimal(value2);
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Cannot parse " + value2 + "; at path " + in.getPreviousPath(), e);
            }
        }
    };

}

