/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.paramnames;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.module.paramnames.ParameterExtractor;
import java.lang.reflect.Executable;
import java.lang.reflect.MalformedParametersException;
import java.lang.reflect.Parameter;

public class ParameterNamesAnnotationIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private final JsonCreator.Mode creatorBinding;
    private final ParameterExtractor parameterExtractor;

    ParameterNamesAnnotationIntrospector(JsonCreator.Mode creatorBinding, ParameterExtractor parameterExtractor) {
        this.creatorBinding = creatorBinding;
        this.parameterExtractor = parameterExtractor;
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember m) {
        if (m instanceof AnnotatedParameter) {
            return this.findParameterName((AnnotatedParameter)m);
        }
        return null;
    }

    private String findParameterName(AnnotatedParameter annotatedParameter) {
        Parameter[] params2;
        try {
            params2 = this.getParameters(annotatedParameter.getOwner());
        }
        catch (MalformedParametersException e) {
            return null;
        }
        Parameter p2 = params2[annotatedParameter.getIndex()];
        return p2.isNamePresent() ? p2.getName() : null;
    }

    private Parameter[] getParameters(AnnotatedWithParams owner2) {
        if (owner2 instanceof AnnotatedConstructor) {
            return this.parameterExtractor.getParameters((Executable)((AnnotatedConstructor)owner2).getAnnotated());
        }
        if (owner2 instanceof AnnotatedMethod) {
            return this.parameterExtractor.getParameters(((AnnotatedMethod)owner2).getAnnotated());
        }
        return null;
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> config, Annotated a) {
        JsonCreator ann = this._findAnnotation(a, JsonCreator.class);
        if (ann != null) {
            JsonCreator.Mode mode2 = ann.mode();
            if (this.creatorBinding != null && mode2 == JsonCreator.Mode.DEFAULT) {
                mode2 = this.creatorBinding;
            }
            return mode2;
        }
        return null;
    }
}

