/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.OptionalLong;

final class OptionalLongSerializer
extends StdScalarSerializer<OptionalLong> {
    private static final long serialVersionUID = 1L;
    static final OptionalLongSerializer INSTANCE = new OptionalLongSerializer();

    public OptionalLongSerializer() {
        super(OptionalLong.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalLong value2) {
        return value2 == null || !value2.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    public void serialize(OptionalLong value2, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value2.isPresent()) {
            jgen.writeNumber(value2.getAsLong());
        } else {
            jgen.writeNull();
        }
    }
}

