/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CompactStringObjectMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final CompactStringObjectMap EMPTY = new CompactStringObjectMap(1, 0, new Object[4]);
    private final int _hashMask;
    private final int _spillCount;
    private final Object[] _hashArea;

    private CompactStringObjectMap(int hashMask, int spillCount, Object[] hashArea) {
        this._hashMask = hashMask;
        this._spillCount = spillCount;
        this._hashArea = hashArea;
    }

    public static <T> CompactStringObjectMap construct(Map<String, T> all) {
        if (all.isEmpty()) {
            return EMPTY;
        }
        int size2 = CompactStringObjectMap.findSize(all.size());
        int mask = size2 - 1;
        int alloc2 = (size2 + (size2 >> 1)) * 2;
        Object[] hashArea = new Object[alloc2];
        int spillCount = 0;
        for (Map.Entry<String, T> entry : all.entrySet()) {
            String key2 = entry.getKey();
            if (key2 == null) continue;
            int slot = key2.hashCode() & mask;
            int ix = slot + slot;
            if (hashArea[ix] != null && hashArea[ix = size2 + (slot >> 1) << 1] != null) {
                ix = (size2 + (size2 >> 1) << 1) + spillCount;
                spillCount += 2;
                if (ix >= hashArea.length) {
                    hashArea = Arrays.copyOf(hashArea, hashArea.length + 4);
                }
            }
            hashArea[ix] = key2;
            hashArea[ix + 1] = entry.getValue();
        }
        return new CompactStringObjectMap(mask, spillCount, hashArea);
    }

    private static final int findSize(int size2) {
        int result2;
        if (size2 <= 5) {
            return 8;
        }
        if (size2 <= 12) {
            return 16;
        }
        int needed = size2 + (size2 >> 2);
        for (result2 = 32; result2 < needed; result2 += result2) {
        }
        return result2;
    }

    public Object find(String key2) {
        int slot = key2.hashCode() & this._hashMask;
        int ix = slot << 1;
        Object match2 = this._hashArea[ix];
        if (match2 == key2 || key2.equals(match2)) {
            return this._hashArea[ix + 1];
        }
        return this._find2(key2, slot, match2);
    }

    private final Object _find2(String key2, int slot, Object match2) {
        if (match2 == null) {
            return null;
        }
        int hashSize = this._hashMask + 1;
        int ix = hashSize + (slot >> 1) << 1;
        match2 = this._hashArea[ix];
        if (key2.equals(match2)) {
            return this._hashArea[ix + 1];
        }
        if (match2 != null) {
            int i2;
            int end2 = i2 + this._spillCount;
            for (i2 = hashSize + (hashSize >> 1) << 1; i2 < end2; i2 += 2) {
                match2 = this._hashArea[i2];
                if (match2 != key2 && !key2.equals(match2)) continue;
                return this._hashArea[i2 + 1];
            }
        }
        return null;
    }

    public Object findCaseInsensitive(String key2) {
        int end2 = this._hashArea.length;
        for (int i2 = 0; i2 < end2; i2 += 2) {
            String s2;
            Object k2 = this._hashArea[i2];
            if (k2 == null || !(s2 = (String)k2).equalsIgnoreCase(key2)) continue;
            return this._hashArea[i2 + 1];
        }
        return null;
    }

    public List<String> keys() {
        int end2 = this._hashArea.length;
        ArrayList<String> keys2 = new ArrayList<String>(end2 >> 2);
        for (int i2 = 0; i2 < end2; i2 += 2) {
            Object key2 = this._hashArea[i2];
            if (key2 == null) continue;
            keys2.add((String)key2);
        }
        return keys2;
    }
}

