/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BeanUtil {
    @Deprecated
    public static String okNameForGetter(AnnotatedMethod am, boolean stdNaming) {
        String name2 = am.getName();
        String str = BeanUtil.okNameForIsGetter(am, name2, stdNaming);
        if (str == null) {
            str = BeanUtil.okNameForRegularGetter(am, name2, stdNaming);
        }
        return str;
    }

    @Deprecated
    public static String okNameForRegularGetter(AnnotatedMethod am, String name2, boolean stdNaming) {
        if (name2.startsWith("get")) {
            if ("getCallbacks".equals(name2) ? BeanUtil.isCglibGetCallbacks(am) : "getMetaClass".equals(name2) && BeanUtil.isGroovyMetaClassGetter(am)) {
                return null;
            }
            return stdNaming ? BeanUtil.stdManglePropertyName(name2, 3) : BeanUtil.legacyManglePropertyName(name2, 3);
        }
        return null;
    }

    @Deprecated
    public static String okNameForIsGetter(AnnotatedMethod am, String name2, boolean stdNaming) {
        Class<?> rt;
        if (name2.startsWith("is") && ((rt = am.getRawType()) == Boolean.class || rt == Boolean.TYPE)) {
            return stdNaming ? BeanUtil.stdManglePropertyName(name2, 2) : BeanUtil.legacyManglePropertyName(name2, 2);
        }
        return null;
    }

    @Deprecated
    public static String okNameForSetter(AnnotatedMethod am, boolean stdNaming) {
        return BeanUtil.okNameForMutator(am, "set", stdNaming);
    }

    @Deprecated
    public static String okNameForMutator(AnnotatedMethod am, String prefix, boolean stdNaming) {
        String name2 = am.getName();
        if (name2.startsWith(prefix)) {
            return stdNaming ? BeanUtil.stdManglePropertyName(name2, prefix.length()) : BeanUtil.legacyManglePropertyName(name2, prefix.length());
        }
        return null;
    }

    public static Object getDefaultValue(JavaType type2) {
        Class<?> cls = type2.getRawClass();
        Class<?> prim = ClassUtil.primitiveType(cls);
        if (prim != null) {
            return ClassUtil.defaultValue(prim);
        }
        if (type2.isContainerType() || type2.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (cls == String.class) {
            return "";
        }
        if (type2.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (type2.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(0L);
            return c;
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod am) {
        Class<?> compType;
        String className;
        Class<?> rt = am.getRawType();
        if (rt.isArray() && (className = (compType = rt.getComponentType()).getName()).contains(".cglib")) {
            return className.startsWith("net.sf.cglib") || className.startsWith("org.hibernate.repackage.cglib") || className.startsWith("org.springframework.cglib");
        }
        return false;
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod am) {
        return am.getRawType().getName().startsWith("groovy.lang");
    }

    protected static String legacyManglePropertyName(String basename2, int offset2) {
        char d;
        int end2 = basename2.length();
        if (end2 == offset2) {
            return null;
        }
        char c = basename2.charAt(offset2);
        if (c == (d = Character.toLowerCase(c))) {
            return basename2.substring(offset2);
        }
        StringBuilder sb = new StringBuilder(end2 - offset2);
        sb.append(d);
        for (int i2 = offset2 + 1; i2 < end2; ++i2) {
            c = basename2.charAt(i2);
            if (c == (d = Character.toLowerCase(c))) {
                sb.append(basename2, i2, end2);
                break;
            }
            sb.append(d);
        }
        return sb.toString();
    }

    public static String stdManglePropertyName(String basename2, int offset2) {
        char c1;
        int end2 = basename2.length();
        if (end2 == offset2) {
            return null;
        }
        char c0 = basename2.charAt(offset2);
        if (c0 == (c1 = Character.toLowerCase(c0))) {
            return basename2.substring(offset2);
        }
        if (offset2 + 1 < end2 && Character.isUpperCase(basename2.charAt(offset2 + 1))) {
            return basename2.substring(offset2);
        }
        StringBuilder sb = new StringBuilder(end2 - offset2);
        sb.append(c1);
        sb.append(basename2, offset2 + 1, end2);
        return sb.toString();
    }

    public static String checkUnsupportedType(JavaType type2) {
        String moduleName;
        String typeName;
        String className = type2.getRawClass().getName();
        if (BeanUtil.isJava8TimeClass(className)) {
            if (className.indexOf(46, 10) >= 0) {
                return null;
            }
            typeName = "Java 8 date/time";
            moduleName = "com.fasterxml.jackson.datatype:jackson-datatype-jsr310";
        } else if (BeanUtil.isJodaTimeClass(className)) {
            typeName = "Joda date/time";
            moduleName = "com.fasterxml.jackson.datatype:jackson-datatype-joda";
        } else if (BeanUtil.isJava8OptionalClass(className)) {
            typeName = "Java 8 optional";
            moduleName = "com.fasterxml.jackson.datatype:jackson-datatype-jdk8";
        } else {
            return null;
        }
        return String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", typeName, ClassUtil.getTypeDescription(type2), moduleName);
    }

    public static boolean isJava8TimeClass(Class<?> rawType) {
        return BeanUtil.isJava8TimeClass(rawType.getName());
    }

    private static boolean isJava8TimeClass(String className) {
        return className.startsWith("java.time.");
    }

    public static boolean isJava8OptionalClass(Class<?> rawType) {
        return BeanUtil.isJava8OptionalClass(rawType.getName());
    }

    private static boolean isJava8OptionalClass(String className) {
        return className.startsWith("java.util.Optional");
    }

    public static boolean isJodaTimeClass(Class<?> rawType) {
        return BeanUtil.isJodaTimeClass(rawType.getName());
    }

    private static boolean isJodaTimeClass(String className) {
        return className.startsWith("org.joda.time.");
    }
}

