/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleNameIdResolver
extends TypeIdResolverBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final MapperConfig<?> _config;
    protected final ConcurrentHashMap<String, String> _typeToId;
    protected final Map<String, JavaType> _idToType;
    protected final boolean _caseInsensitive;

    protected SimpleNameIdResolver(MapperConfig<?> config, JavaType baseType, ConcurrentHashMap<String, String> typeToId, HashMap<String, JavaType> idToType) {
        super(baseType, config.getTypeFactory());
        this._config = config;
        this._typeToId = typeToId;
        this._idToType = idToType;
        this._caseInsensitive = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
    }

    public static SimpleNameIdResolver construct(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        HashMap<String, JavaType> idToType;
        ConcurrentHashMap<String, String> typeToId;
        if (forSer == forDeser) {
            throw new IllegalArgumentException();
        }
        if (forSer) {
            typeToId = new ConcurrentHashMap<String, String>();
            idToType = null;
        } else {
            idToType = new HashMap<String, JavaType>();
            typeToId = new ConcurrentHashMap(4);
        }
        boolean caseInsensitive = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
        if (subtypes != null) {
            for (NamedType t : subtypes) {
                JavaType prev;
                String id2;
                Class<?> cls = t.getType();
                String string2 = id2 = t.hasName() ? t.getName() : SimpleNameIdResolver._defaultTypeId(cls);
                if (forSer) {
                    typeToId.put(cls.getName(), id2);
                }
                if (!forDeser) continue;
                if (caseInsensitive) {
                    id2 = id2.toLowerCase();
                }
                if ((prev = idToType.get(id2)) != null && cls.isAssignableFrom(prev.getRawClass())) continue;
                idToType.put(id2, config.constructType(cls));
            }
        }
        return new SimpleNameIdResolver(config, baseType, typeToId, idToType);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.SIMPLE_NAME;
    }

    @Override
    public String idFromValue(Object value2) {
        return this.idFromClass(value2.getClass());
    }

    protected String idFromClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String key2 = clazz.getName();
        String name2 = this._typeToId.get(key2);
        if (name2 == null) {
            Class<?> cls = this._typeFactory.constructType(clazz).getRawClass();
            if (this._config.isAnnotationProcessingEnabled()) {
                BeanDescription beanDesc = this._config.introspectClassAnnotations(cls);
                name2 = this._config.getAnnotationIntrospector().findTypeName(beanDesc.getClassInfo());
            }
            if (name2 == null) {
                name2 = SimpleNameIdResolver._defaultTypeId(cls);
            }
            this._typeToId.put(key2, name2);
        }
        return name2;
    }

    @Override
    public String idFromValueAndType(Object value2, Class<?> type2) {
        if (value2 == null) {
            return this.idFromClass(type2);
        }
        return this.idFromValue(value2);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id2) {
        return this._typeFromId(id2);
    }

    protected JavaType _typeFromId(String id2) {
        if (this._caseInsensitive) {
            id2 = id2.toLowerCase();
        }
        return this._idToType.get(id2);
    }

    @Override
    public String getDescForKnownTypeIds() {
        TreeSet<String> ids = new TreeSet<String>();
        for (Map.Entry<String, JavaType> entry : this._idToType.entrySet()) {
            if (!entry.getValue().isConcrete()) continue;
            ids.add(entry.getKey());
        }
        return ids.toString();
    }

    public String toString() {
        return String.format("[%s; id-to-type=%s]", this.getClass().getName(), this._idToType);
    }

    protected static String _defaultTypeId(Class<?> cls) {
        String n = cls.getName();
        int ix = Math.max(n.lastIndexOf(46), n.lastIndexOf(36));
        return ix < 0 ? n : n.substring(ix + 1);
    }
}

