/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class NioPathDeserializer
extends StdScalarDeserializer<Path> {
    private static final long serialVersionUID = 1L;
    private static final boolean areWindowsFilePathsSupported;

    public NioPathDeserializer() {
        super(Path.class);
    }

    @Override
    public Path deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        URI uri;
        if (!p2.hasToken(JsonToken.VALUE_STRING)) {
            return (Path)ctxt.handleUnexpectedToken(Path.class, p2);
        }
        String value2 = p2.getText();
        if (value2.indexOf(58) < 0) {
            return Paths.get(value2, new String[0]);
        }
        if (areWindowsFilePathsSupported && value2.length() >= 2 && Character.isLetter(value2.charAt(0)) && value2.charAt(1) == ':') {
            return Paths.get(value2, new String[0]);
        }
        try {
            uri = new URI(value2);
        }
        catch (URISyntaxException e) {
            return (Path)ctxt.handleInstantiationProblem(this.handledType(), value2, e);
        }
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException cause2) {
            try {
                String scheme = uri.getScheme();
                for (FileSystemProvider provider : ServiceLoader.load(FileSystemProvider.class)) {
                    if (!provider.getScheme().equalsIgnoreCase(scheme)) continue;
                    return provider.getPath(uri);
                }
                return (Path)ctxt.handleInstantiationProblem(this.handledType(), value2, cause2);
            }
            catch (ServiceConfigurationError e) {
                e.addSuppressed(cause2);
                return (Path)ctxt.handleInstantiationProblem(this.handledType(), value2, e);
            }
        }
        catch (Exception e) {
            return (Path)ctxt.handleInstantiationProblem(this.handledType(), value2, e);
        }
    }

    static {
        boolean isWindowsRootFound = false;
        for (File file2 : File.listRoots()) {
            String path2 = file2.getPath();
            if (path2.length() < 2 || !Character.isLetter(path2.charAt(0)) || path2.charAt(1) != ':') continue;
            isWindowsRootFound = true;
            break;
        }
        areWindowsFilePathsSupported = isWindowsRootFound;
    }
}

