/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class ByteQuadsCanonicalizer {
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    private static final int MIN_HASH_SIZE = 16;
    protected static final int MAX_ENTRIES_FOR_REUSE = 6000;
    protected final ByteQuadsCanonicalizer _parent;
    protected final AtomicReference<TableInfo> _tableInfo;
    protected final int _seed;
    protected final InternCache _interner;
    protected final boolean _failOnDoS;
    protected int[] _hashArea;
    protected int _hashSize;
    protected int _secondaryStart;
    protected int _tertiaryStart;
    protected int _tertiaryShift;
    protected int _count;
    protected String[] _names;
    protected int _spilloverEnd;
    protected int _longNameOffset;
    protected boolean _hashShared;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;

    private ByteQuadsCanonicalizer(int sz, int seed2) {
        this._parent = null;
        this._count = 0;
        this._hashShared = true;
        this._seed = seed2;
        this._interner = null;
        this._failOnDoS = true;
        if (sz < 16) {
            sz = 16;
        } else if ((sz & sz - 1) != 0) {
            int curr;
            for (curr = 16; curr < sz; curr += curr) {
            }
            sz = curr;
        }
        this._tableInfo = new AtomicReference<TableInfo>(TableInfo.createInitial(sz));
    }

    private ByteQuadsCanonicalizer(ByteQuadsCanonicalizer parent, int seed2, TableInfo state2, boolean intern2, boolean failOnDoS) {
        this._parent = parent;
        this._seed = seed2;
        this._interner = intern2 ? InternCache.instance : null;
        this._failOnDoS = failOnDoS;
        this._tableInfo = null;
        this._count = state2.count;
        this._hashSize = state2.size;
        this._secondaryStart = this._hashSize << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = state2.tertiaryShift;
        this._hashArea = state2.mainHash;
        this._names = state2.names;
        this._spilloverEnd = state2.spilloverEnd;
        this._longNameOffset = state2.longNameOffset;
        this._hashShared = true;
    }

    private ByteQuadsCanonicalizer(TableInfo state2) {
        int end2;
        this._parent = null;
        this._seed = 0;
        this._interner = null;
        this._failOnDoS = true;
        this._tableInfo = null;
        this._count = -1;
        this._hashArea = state2.mainHash;
        this._names = state2.names;
        this._hashSize = state2.size;
        this._secondaryStart = end2 = this._hashArea.length;
        this._tertiaryStart = end2;
        this._tertiaryShift = 1;
        this._spilloverEnd = end2;
        this._longNameOffset = end2;
        this._hashShared = true;
    }

    public static ByteQuadsCanonicalizer createRoot() {
        long now2 = System.currentTimeMillis();
        int seed2 = (int)now2 + (int)(now2 >>> 32) | 1;
        return ByteQuadsCanonicalizer.createRoot(seed2);
    }

    protected static ByteQuadsCanonicalizer createRoot(int seed2) {
        return new ByteQuadsCanonicalizer(64, seed2);
    }

    public ByteQuadsCanonicalizer makeChild(int flags2) {
        return new ByteQuadsCanonicalizer(this, this._seed, this._tableInfo.get(), JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(flags2), JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(flags2));
    }

    public ByteQuadsCanonicalizer makeChildOrPlaceholder(int flags2) {
        if (JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(flags2)) {
            return new ByteQuadsCanonicalizer(this, this._seed, this._tableInfo.get(), JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(flags2), JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(flags2));
        }
        return new ByteQuadsCanonicalizer(this._tableInfo.get());
    }

    public void release() {
        if (this._parent != null && this.maybeDirty()) {
            this._parent.mergeChild(new TableInfo(this));
            this._hashShared = true;
        }
    }

    private void mergeChild(TableInfo childState) {
        int childCount = childState.count;
        TableInfo currState = this._tableInfo.get();
        if (childCount == currState.count) {
            return;
        }
        if (childCount > 6000) {
            childState = TableInfo.createInitial(64);
        }
        this._tableInfo.compareAndSet(currState, childState);
    }

    public int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().count;
        }
        return this._count;
    }

    public int bucketCount() {
        return this._hashSize;
    }

    public boolean maybeDirty() {
        return !this._hashShared;
    }

    public int hashSeed() {
        return this._seed;
    }

    public boolean isCanonicalizing() {
        return this._parent != null;
    }

    public int primaryCount() {
        int count2 = 0;
        int end2 = this._secondaryStart;
        for (int offset2 = 3; offset2 < end2; offset2 += 4) {
            if (this._hashArea[offset2] == 0) continue;
            ++count2;
        }
        return count2;
    }

    public int secondaryCount() {
        int count2 = 0;
        int end2 = this._tertiaryStart;
        for (int offset2 = this._secondaryStart + 3; offset2 < end2; offset2 += 4) {
            if (this._hashArea[offset2] == 0) continue;
            ++count2;
        }
        return count2;
    }

    public int tertiaryCount() {
        int offset2;
        int count2 = 0;
        int end2 = offset2 + this._hashSize;
        for (offset2 = this._tertiaryStart + 3; offset2 < end2; offset2 += 4) {
            if (this._hashArea[offset2] == 0) continue;
            ++count2;
        }
        return count2;
    }

    public int spilloverCount() {
        return this._spilloverEnd - this._spilloverStart() >> 2;
    }

    public int totalCount() {
        int count2 = 0;
        int end2 = this._hashSize << 3;
        for (int offset2 = 3; offset2 < end2; offset2 += 4) {
            if (this._hashArea[offset2] == 0) continue;
            ++count2;
        }
        return count2;
    }

    public String toString() {
        int pri = this.primaryCount();
        int sec2 = this.secondaryCount();
        int tert = this.tertiaryCount();
        int spill = this.spilloverCount();
        int total2 = this.totalCount();
        return String.format("[%s: size=%d, hashSize=%d, %d/%d/%d/%d pri/sec/ter/spill (=%s), total:%d]", this.getClass().getName(), this._count, this._hashSize, pri, sec2, tert, spill, pri + sec2 + tert + spill, total2);
    }

    public String findName(int q1) {
        int offset2;
        int[] hashArea = this._hashArea;
        int offset3 = this._calcOffset(this.calcHash(q1));
        int len = hashArea[offset3 + 3];
        if (len == 1) {
            if (hashArea[offset3] == q1) {
                return this._names[offset3 >> 2];
            }
        } else if (len == 0) {
            return null;
        }
        if ((len = hashArea[(offset2 = this._secondaryStart + (offset3 >> 3 << 2)) + 3]) == 1) {
            if (hashArea[offset2] == q1) {
                return this._names[offset2 >> 2];
            }
        } else if (len == 0) {
            return null;
        }
        return this._findSecondary(offset3, q1);
    }

    public String findName(int q1, int q2) {
        int offset2;
        int[] hashArea = this._hashArea;
        int offset3 = this._calcOffset(this.calcHash(q1, q2));
        int len = hashArea[offset3 + 3];
        if (len == 2) {
            if (q1 == hashArea[offset3] && q2 == hashArea[offset3 + 1]) {
                return this._names[offset3 >> 2];
            }
        } else if (len == 0) {
            return null;
        }
        if ((len = hashArea[(offset2 = this._secondaryStart + (offset3 >> 3 << 2)) + 3]) == 2) {
            if (q1 == hashArea[offset2] && q2 == hashArea[offset2 + 1]) {
                return this._names[offset2 >> 2];
            }
        } else if (len == 0) {
            return null;
        }
        return this._findSecondary(offset3, q1, q2);
    }

    public String findName(int q1, int q2, int q3) {
        int offset2;
        int[] hashArea = this._hashArea;
        int offset3 = this._calcOffset(this.calcHash(q1, q2, q3));
        int len = hashArea[offset3 + 3];
        if (len == 3) {
            if (q1 == hashArea[offset3] && hashArea[offset3 + 1] == q2 && hashArea[offset3 + 2] == q3) {
                return this._names[offset3 >> 2];
            }
        } else if (len == 0) {
            return null;
        }
        if ((len = hashArea[(offset2 = this._secondaryStart + (offset3 >> 3 << 2)) + 3]) == 3) {
            if (q1 == hashArea[offset2] && hashArea[offset2 + 1] == q2 && hashArea[offset2 + 2] == q3) {
                return this._names[offset2 >> 2];
            }
        } else if (len == 0) {
            return null;
        }
        return this._findSecondary(offset3, q1, q2, q3);
    }

    public String findName(int[] q, int qlen) {
        if (qlen < 4) {
            switch (qlen) {
                case 3: {
                    return this.findName(q[0], q[1], q[2]);
                }
                case 2: {
                    return this.findName(q[0], q[1]);
                }
                case 1: {
                    return this.findName(q[0]);
                }
            }
            return "";
        }
        int hash2 = this.calcHash(q, qlen);
        int offset2 = this._calcOffset(hash2);
        int[] hashArea = this._hashArea;
        int len = hashArea[offset2 + 3];
        if (hash2 == hashArea[offset2] && len == qlen && this._verifyLongName(q, qlen, hashArea[offset2 + 1])) {
            return this._names[offset2 >> 2];
        }
        if (len == 0) {
            return null;
        }
        int offset22 = this._secondaryStart + (offset2 >> 3 << 2);
        int len2 = hashArea[offset22 + 3];
        if (hash2 == hashArea[offset22] && len2 == qlen && this._verifyLongName(q, qlen, hashArea[offset22 + 1])) {
            return this._names[offset22 >> 2];
        }
        return this._findSecondary(offset2, hash2, q, qlen);
    }

    private final int _calcOffset(int hash2) {
        int ix = hash2 & this._hashSize - 1;
        return ix << 2;
    }

    private String _findSecondary(int origOffset, int q1) {
        int offset2;
        int[] hashArea = this._hashArea;
        int bucketSize = 1 << this._tertiaryShift;
        int end2 = offset2 + bucketSize;
        for (offset2 = this._tertiaryStart + (origOffset >> this._tertiaryShift + 2 << this._tertiaryShift); offset2 < end2; offset2 += 4) {
            int len = hashArea[offset2 + 3];
            if (q1 == hashArea[offset2] && 1 == len) {
                return this._names[offset2 >> 2];
            }
            if (len != 0) continue;
            return null;
        }
        for (offset2 = this._spilloverStart(); offset2 < this._spilloverEnd; offset2 += 4) {
            if (q1 != hashArea[offset2] || 1 != hashArea[offset2 + 3]) continue;
            return this._names[offset2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int origOffset, int q1, int q2) {
        int offset2;
        int[] hashArea = this._hashArea;
        int bucketSize = 1 << this._tertiaryShift;
        int end2 = offset2 + bucketSize;
        for (offset2 = this._tertiaryStart + (origOffset >> this._tertiaryShift + 2 << this._tertiaryShift); offset2 < end2; offset2 += 4) {
            int len = hashArea[offset2 + 3];
            if (q1 == hashArea[offset2] && q2 == hashArea[offset2 + 1] && 2 == len) {
                return this._names[offset2 >> 2];
            }
            if (len != 0) continue;
            return null;
        }
        for (offset2 = this._spilloverStart(); offset2 < this._spilloverEnd; offset2 += 4) {
            if (q1 != hashArea[offset2] || q2 != hashArea[offset2 + 1] || 2 != hashArea[offset2 + 3]) continue;
            return this._names[offset2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int origOffset, int q1, int q2, int q3) {
        int offset2;
        int[] hashArea = this._hashArea;
        int bucketSize = 1 << this._tertiaryShift;
        int end2 = offset2 + bucketSize;
        for (offset2 = this._tertiaryStart + (origOffset >> this._tertiaryShift + 2 << this._tertiaryShift); offset2 < end2; offset2 += 4) {
            int len = hashArea[offset2 + 3];
            if (q1 == hashArea[offset2] && q2 == hashArea[offset2 + 1] && q3 == hashArea[offset2 + 2] && 3 == len) {
                return this._names[offset2 >> 2];
            }
            if (len != 0) continue;
            return null;
        }
        for (offset2 = this._spilloverStart(); offset2 < this._spilloverEnd; offset2 += 4) {
            if (q1 != hashArea[offset2] || q2 != hashArea[offset2 + 1] || q3 != hashArea[offset2 + 2] || 3 != hashArea[offset2 + 3]) continue;
            return this._names[offset2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int origOffset, int hash2, int[] q, int qlen) {
        int offset2;
        int[] hashArea = this._hashArea;
        int bucketSize = 1 << this._tertiaryShift;
        int end2 = offset2 + bucketSize;
        for (offset2 = this._tertiaryStart + (origOffset >> this._tertiaryShift + 2 << this._tertiaryShift); offset2 < end2; offset2 += 4) {
            int len = hashArea[offset2 + 3];
            if (hash2 == hashArea[offset2] && qlen == len && this._verifyLongName(q, qlen, hashArea[offset2 + 1])) {
                return this._names[offset2 >> 2];
            }
            if (len != 0) continue;
            return null;
        }
        for (offset2 = this._spilloverStart(); offset2 < this._spilloverEnd; offset2 += 4) {
            if (hash2 != hashArea[offset2] || qlen != hashArea[offset2 + 3] || !this._verifyLongName(q, qlen, hashArea[offset2 + 1])) continue;
            return this._names[offset2 >> 2];
        }
        return null;
    }

    private boolean _verifyLongName(int[] q, int qlen, int spillOffset) {
        int[] hashArea = this._hashArea;
        int ix = 0;
        switch (qlen) {
            default: {
                return this._verifyLongName2(q, qlen, spillOffset);
            }
            case 8: {
                if (q[ix++] != hashArea[spillOffset++]) {
                    return false;
                }
            }
            case 7: {
                if (q[ix++] != hashArea[spillOffset++]) {
                    return false;
                }
            }
            case 6: {
                if (q[ix++] != hashArea[spillOffset++]) {
                    return false;
                }
            }
            case 5: {
                if (q[ix++] == hashArea[spillOffset++]) break;
                return false;
            }
            case 4: 
        }
        if (q[ix++] != hashArea[spillOffset++]) {
            return false;
        }
        if (q[ix++] != hashArea[spillOffset++]) {
            return false;
        }
        if (q[ix++] != hashArea[spillOffset++]) {
            return false;
        }
        return q[ix++] == hashArea[spillOffset++];
    }

    private boolean _verifyLongName2(int[] q, int qlen, int spillOffset) {
        int ix = 0;
        do {
            if (q[ix++] == this._hashArea[spillOffset++]) continue;
            return false;
        } while (ix < qlen);
        return true;
    }

    public String addName(String name2, int q1) throws StreamConstraintsException {
        this._verifySharing();
        if (this._interner != null) {
            name2 = this._interner.intern(name2);
        }
        int offset2 = this._findOffsetForAdd(this.calcHash(q1));
        this._hashArea[offset2] = q1;
        this._hashArea[offset2 + 3] = 1;
        this._names[offset2 >> 2] = name2;
        ++this._count;
        return name2;
    }

    public String addName(String name2, int q1, int q2) throws StreamConstraintsException {
        this._verifySharing();
        if (this._interner != null) {
            name2 = this._interner.intern(name2);
        }
        int hash2 = this.calcHash(q1, q2);
        int offset2 = this._findOffsetForAdd(hash2);
        this._hashArea[offset2] = q1;
        this._hashArea[offset2 + 1] = q2;
        this._hashArea[offset2 + 3] = 2;
        this._names[offset2 >> 2] = name2;
        ++this._count;
        return name2;
    }

    public String addName(String name2, int q1, int q2, int q3) throws StreamConstraintsException {
        this._verifySharing();
        if (this._interner != null) {
            name2 = this._interner.intern(name2);
        }
        int offset2 = this._findOffsetForAdd(this.calcHash(q1, q2, q3));
        this._hashArea[offset2] = q1;
        this._hashArea[offset2 + 1] = q2;
        this._hashArea[offset2 + 2] = q3;
        this._hashArea[offset2 + 3] = 3;
        this._names[offset2 >> 2] = name2;
        ++this._count;
        return name2;
    }

    public String addName(String name2, int[] q, int qlen) throws StreamConstraintsException {
        this._verifySharing();
        if (this._interner != null) {
            name2 = this._interner.intern(name2);
        }
        switch (qlen) {
            case 1: {
                int offset2 = this._findOffsetForAdd(this.calcHash(q[0]));
                this._hashArea[offset2] = q[0];
                this._hashArea[offset2 + 3] = 1;
                break;
            }
            case 2: {
                int offset2 = this._findOffsetForAdd(this.calcHash(q[0], q[1]));
                this._hashArea[offset2] = q[0];
                this._hashArea[offset2 + 1] = q[1];
                this._hashArea[offset2 + 3] = 2;
                break;
            }
            case 3: {
                int offset2 = this._findOffsetForAdd(this.calcHash(q[0], q[1], q[2]));
                this._hashArea[offset2] = q[0];
                this._hashArea[offset2 + 1] = q[1];
                this._hashArea[offset2 + 2] = q[2];
                this._hashArea[offset2 + 3] = 3;
                break;
            }
            default: {
                int longStart;
                int hash2 = this.calcHash(q, qlen);
                int offset2 = this._findOffsetForAdd(hash2);
                this._hashArea[offset2] = hash2;
                this._hashArea[offset2 + 1] = longStart = this._appendLongName(q, qlen);
                this._hashArea[offset2 + 3] = qlen;
            }
        }
        this._names[offset2 >> 2] = name2;
        ++this._count;
        return name2;
    }

    private void _verifySharing() {
        if (this._hashShared) {
            if (this._parent == null) {
                if (this._count == 0) {
                    throw new IllegalStateException("Internal error: Cannot add names to Root symbol table");
                }
                throw new IllegalStateException("Internal error: Cannot add names to Placeholder symbol table");
            }
            this._hashArea = Arrays.copyOf(this._hashArea, this._hashArea.length);
            this._names = Arrays.copyOf(this._names, this._names.length);
            this._hashShared = false;
        }
    }

    private int _findOffsetForAdd(int hash2) throws StreamConstraintsException {
        int[] hashArea = this._hashArea;
        int offset2 = this._calcOffset(hash2);
        if (hashArea[offset2 + 3] == 0) {
            return offset2;
        }
        if (this._checkNeedForRehash()) {
            return this._resizeAndFindOffsetForAdd(hash2);
        }
        int offset22 = this._secondaryStart + (offset2 >> 3 << 2);
        if (hashArea[offset22 + 3] == 0) {
            return offset22;
        }
        int bucketSize = 1 << this._tertiaryShift;
        int end2 = offset22 + bucketSize;
        for (offset22 = this._tertiaryStart + (offset2 >> this._tertiaryShift + 2 << this._tertiaryShift); offset22 < end2; offset22 += 4) {
            if (hashArea[offset22 + 3] != 0) continue;
            return offset22;
        }
        offset2 = this._spilloverEnd;
        this._spilloverEnd += 4;
        end2 = this._hashSize << 3;
        if (this._spilloverEnd >= end2) {
            if (this._failOnDoS) {
                this._reportTooManyCollisions();
            }
            return this._resizeAndFindOffsetForAdd(hash2);
        }
        return offset2;
    }

    private int _resizeAndFindOffsetForAdd(int hash2) throws StreamConstraintsException {
        this.rehash();
        int offset2 = this._calcOffset(hash2);
        int[] hashArea = this._hashArea;
        if (hashArea[offset2 + 3] == 0) {
            return offset2;
        }
        int offset22 = this._secondaryStart + (offset2 >> 3 << 2);
        if (hashArea[offset22 + 3] == 0) {
            return offset22;
        }
        int bucketSize = 1 << this._tertiaryShift;
        int end2 = offset22 + bucketSize;
        for (offset22 = this._tertiaryStart + (offset2 >> this._tertiaryShift + 2 << this._tertiaryShift); offset22 < end2; offset22 += 4) {
            if (hashArea[offset22 + 3] != 0) continue;
            return offset22;
        }
        offset2 = this._spilloverEnd;
        this._spilloverEnd += 4;
        return offset2;
    }

    static int multiplyByFourFifths(int number) {
        return (int)((long)number * 0xCCCCCCCDL >>> 32);
    }

    private boolean _checkNeedForRehash() {
        int spillCount;
        return this._count > this._hashSize >> 1 && ((spillCount = this._spilloverEnd - this._spilloverStart() >> 2) > 1 + this._count >> 7 || this._count > ByteQuadsCanonicalizer.multiplyByFourFifths(this._hashSize));
    }

    private int _appendLongName(int[] quads, int qlen) {
        int start2 = this._longNameOffset;
        if (start2 + qlen > this._hashArea.length) {
            int toAdd = start2 + qlen - this._hashArea.length;
            int minAdd = Math.min(4096, this._hashSize);
            int newSize = this._hashArea.length + Math.max(toAdd, minAdd);
            this._hashArea = Arrays.copyOf(this._hashArea, newSize);
        }
        System.arraycopy(quads, 0, this._hashArea, start2, qlen);
        this._longNameOffset += qlen;
        return start2;
    }

    public int calcHash(int q1) {
        int hash2 = q1 ^ this._seed;
        hash2 += hash2 >>> 16;
        hash2 ^= hash2 << 3;
        hash2 += hash2 >>> 12;
        return hash2;
    }

    public int calcHash(int q1, int q2) {
        int hash2 = q1;
        hash2 += hash2 >>> 15;
        hash2 ^= hash2 >>> 9;
        hash2 += q2 * 33;
        hash2 ^= this._seed;
        hash2 += hash2 >>> 16;
        hash2 ^= hash2 >>> 4;
        hash2 += hash2 << 3;
        return hash2;
    }

    public int calcHash(int q1, int q2, int q3) {
        int hash2 = q1 ^ this._seed;
        hash2 += hash2 >>> 9;
        hash2 *= 31;
        hash2 += q2;
        hash2 *= 33;
        hash2 += hash2 >>> 15;
        hash2 ^= q3;
        hash2 += hash2 >>> 4;
        hash2 += hash2 >>> 15;
        hash2 ^= hash2 << 9;
        return hash2;
    }

    public int calcHash(int[] q, int qlen) {
        if (qlen < 4) {
            throw new IllegalArgumentException("qlen is too short, needs to be at least 4");
        }
        int hash2 = q[0] ^ this._seed;
        hash2 += hash2 >>> 9;
        hash2 += q[1];
        hash2 += hash2 >>> 15;
        hash2 *= 33;
        hash2 ^= q[2];
        hash2 += hash2 >>> 4;
        for (int i2 = 3; i2 < qlen; ++i2) {
            int next2 = q[i2];
            next2 ^= next2 >> 21;
            hash2 += next2;
        }
        hash2 *= 65599;
        hash2 += hash2 >>> 19;
        hash2 ^= hash2 << 5;
        return hash2;
    }

    private void rehash() throws StreamConstraintsException {
        this._hashShared = false;
        int[] oldHashArea = this._hashArea;
        String[] oldNames = this._names;
        int oldSize = this._hashSize;
        int oldCount = this._count;
        int newSize = oldSize + oldSize;
        int oldEnd = this._spilloverEnd;
        if (newSize > 65536) {
            this.nukeSymbols(true);
            return;
        }
        this._hashArea = new int[oldHashArea.length + (oldSize << 3)];
        this._hashSize = newSize;
        this._secondaryStart = newSize << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = ByteQuadsCanonicalizer._calcTertiaryShift(newSize);
        this._names = new String[oldNames.length << 1];
        this.nukeSymbols(false);
        int copyCount = 0;
        int[] q = new int[16];
        int end2 = oldEnd;
        block5: for (int offset2 = 0; offset2 < end2; offset2 += 4) {
            int len = oldHashArea[offset2 + 3];
            if (len == 0) continue;
            ++copyCount;
            String name2 = oldNames[offset2 >> 2];
            switch (len) {
                case 1: {
                    q[0] = oldHashArea[offset2];
                    this.addName(name2, q, 1);
                    continue block5;
                }
                case 2: {
                    q[0] = oldHashArea[offset2];
                    q[1] = oldHashArea[offset2 + 1];
                    this.addName(name2, q, 2);
                    continue block5;
                }
                case 3: {
                    q[0] = oldHashArea[offset2];
                    q[1] = oldHashArea[offset2 + 1];
                    q[2] = oldHashArea[offset2 + 2];
                    this.addName(name2, q, 3);
                    continue block5;
                }
                default: {
                    if (len > q.length) {
                        q = new int[len];
                    }
                    int qoff = oldHashArea[offset2 + 1];
                    System.arraycopy(oldHashArea, qoff, q, 0, len);
                    this.addName(name2, q, len);
                }
            }
        }
        if (copyCount != oldCount) {
            throw new IllegalStateException("Internal error: Failed rehash(), old count=" + oldCount + ", copyCount=" + copyCount);
        }
    }

    private void nukeSymbols(boolean fill2) {
        this._count = 0;
        this._spilloverEnd = this._spilloverStart();
        this._longNameOffset = this._hashSize << 3;
        if (fill2) {
            Arrays.fill(this._hashArea, 0);
            Arrays.fill(this._names, null);
        }
    }

    private final int _spilloverStart() {
        int offset2 = this._hashSize;
        return (offset2 << 3) - offset2;
    }

    protected void _reportTooManyCollisions() throws StreamConstraintsException {
        if (this._hashSize <= 1024) {
            return;
        }
        throw new StreamConstraintsException("Spill-over slots in symbol table with " + this._count + " entries, hash area of " + this._hashSize + " slots is now full (all " + (this._hashSize >> 3) + " slots -- suspect a DoS attack based on hash collisions. You can disable the check via `JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW`");
    }

    static int _calcTertiaryShift(int primarySlots) {
        int tertSlots = primarySlots >> 2;
        if (tertSlots < 64) {
            return 4;
        }
        if (tertSlots <= 256) {
            return 5;
        }
        if (tertSlots <= 1024) {
            return 6;
        }
        return 7;
    }

    private static final class TableInfo {
        public final int size;
        public final int count;
        public final int tertiaryShift;
        public final int[] mainHash;
        public final String[] names;
        public final int spilloverEnd;
        public final int longNameOffset;

        public TableInfo(int size2, int count2, int tertiaryShift, int[] mainHash, String[] names2, int spilloverEnd, int longNameOffset) {
            this.size = size2;
            this.count = count2;
            this.tertiaryShift = tertiaryShift;
            this.mainHash = mainHash;
            this.names = names2;
            this.spilloverEnd = spilloverEnd;
            this.longNameOffset = longNameOffset;
        }

        public TableInfo(ByteQuadsCanonicalizer src) {
            this.size = src._hashSize;
            this.count = src._count;
            this.tertiaryShift = src._tertiaryShift;
            this.mainHash = src._hashArea;
            this.names = src._names;
            this.spilloverEnd = src._spilloverEnd;
            this.longNameOffset = src._longNameOffset;
        }

        public static TableInfo createInitial(int sz) {
            int hashAreaSize = sz << 3;
            int tertShift = ByteQuadsCanonicalizer._calcTertiaryShift(sz);
            return new TableInfo(sz, 0, tertShift, new int[hashAreaSize], new String[sz << 1], hashAreaSize - sz, hashAreaSize);
        }
    }
}

