/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractBigIntegerParser;
import com.fasterxml.jackson.core.io.doubleparser.AbstractNumberParser;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import com.fasterxml.jackson.core.io.doubleparser.FastIntegerMath;
import com.fasterxml.jackson.core.io.doubleparser.ParseDigitsTaskByteArray;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.NavigableMap;

class JavaBigIntegerFromByteArray
extends AbstractBigIntegerParser {
    JavaBigIntegerFromByteArray() {
    }

    public BigInteger parseBigIntegerString(byte[] str, int offset2, int length2, int radix) throws NumberFormatException {
        try {
            boolean isNegative2;
            int endIndex = AbstractNumberParser.checkBounds(str.length, offset2, length2);
            int index2 = offset2;
            byte ch = str[index2];
            boolean bl = isNegative2 = ch == 45;
            if ((isNegative2 || ch == 43) && (ch = JavaBigIntegerFromByteArray.charAt(str, ++index2, endIndex)) == 0) {
                throw new NumberFormatException("illegal syntax");
            }
            switch (radix) {
                case 10: {
                    return this.parseDecDigits(str, index2, endIndex, isNegative2);
                }
                case 16: {
                    return this.parseHexDigits(str, index2, endIndex, isNegative2);
                }
            }
            return new BigInteger(new String(str, offset2, length2, StandardCharsets.ISO_8859_1), radix);
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e);
            throw nfe;
        }
    }

    private BigInteger parseDecDigits(byte[] str, int from, int to, boolean isNegative2) {
        int numDigits = to - from;
        if (JavaBigIntegerFromByteArray.hasManyDigits(numDigits)) {
            return this.parseManyDecDigits(str, from, to, isNegative2);
        }
        int preroll = from + (numDigits & 7);
        long significand = FastDoubleSwar.tryToParseUpTo7Digits(str, from, preroll);
        boolean success = significand >= 0L;
        for (from = preroll; from < to; from += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigitsUtf8(str, from);
            success &= addend >= 0;
            significand = significand * 100000000L + (long)addend;
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(isNegative2 ? -significand : significand);
    }

    private BigInteger parseHexDigits(byte[] str, int from, int to, boolean isNegative2) {
        int numDigits = to - (from = this.skipZeroes(str, from, to));
        if (numDigits <= 0) {
            return BigInteger.ZERO;
        }
        JavaBigIntegerFromByteArray.checkHexBigIntegerBounds(numDigits);
        byte[] bytes2 = new byte[(numDigits + 1 >> 1) + 1];
        int index2 = 1;
        boolean illegalDigits = false;
        if ((numDigits & 1) != 0) {
            byte chLow = str[from++];
            int valueLow = JavaBigIntegerFromByteArray.lookupHex(chLow);
            bytes2[index2++] = (byte)valueLow;
            illegalDigits = valueLow < 0;
        }
        int prerollLimit = from + (to - from & 7);
        while (from < prerollLimit) {
            byte chHigh = str[from];
            byte chLow = str[from + 1];
            int valueHigh = JavaBigIntegerFromByteArray.lookupHex(chHigh);
            int valueLow = JavaBigIntegerFromByteArray.lookupHex(chLow);
            bytes2[index2++] = (byte)(valueHigh << 4 | valueLow);
            illegalDigits |= valueHigh < 0 || valueLow < 0;
            from += 2;
        }
        while (from < to) {
            long value2 = FastDoubleSwar.tryToParseEightHexDigits(str, from);
            FastDoubleSwar.writeIntBE(bytes2, index2, (int)value2);
            illegalDigits |= value2 < 0L;
            from += 8;
            index2 += 4;
        }
        if (illegalDigits) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger result2 = new BigInteger(bytes2);
        return isNegative2 ? result2.negate() : result2;
    }

    private BigInteger parseManyDecDigits(byte[] str, int from, int to, boolean isNegative2) {
        from = this.skipZeroes(str, from, to);
        int numDigits = to - from;
        JavaBigIntegerFromByteArray.checkDecBigIntegerBounds(numDigits);
        NavigableMap<Integer, BigInteger> powersOfTen = FastIntegerMath.fillPowersOf10Floor16(from, to);
        BigInteger result2 = ParseDigitsTaskByteArray.parseDigitsRecursive(str, from, to, powersOfTen, 400);
        return isNegative2 ? result2.negate() : result2;
    }

    private int skipZeroes(byte[] str, int from, int to) {
        while (from < to - 8 && FastDoubleSwar.isEightZeroes(str, from)) {
            from += 8;
        }
        while (from < to && str[from] == 48) {
            ++from;
        }
        return from;
    }
}

