/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractBigDecimalParser;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import com.fasterxml.jackson.core.io.doubleparser.FastIntegerMath;
import com.fasterxml.jackson.core.io.doubleparser.FftMultiplier;
import com.fasterxml.jackson.core.io.doubleparser.ParseDigitsTaskCharSequence;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NavigableMap;

final class JavaBigDecimalFromCharSequence
extends AbstractBigDecimalParser {
    public BigDecimal parseBigDecimalString(CharSequence str, int offset2, int length2) {
        try {
            int exponentIndicatorIndex;
            long exponent2;
            int digitCount;
            boolean isNegative2;
            int index2;
            int size2 = str.length();
            int endIndex = JavaBigDecimalFromCharSequence.checkBounds(size2, offset2, length2);
            if (JavaBigDecimalFromCharSequence.hasManyDigits(length2)) {
                return this.parseBigDecimalStringWithManyDigits(str, offset2, length2);
            }
            long significand = 0L;
            int decimalPointIndex = -1;
            char ch = JavaBigDecimalFromCharSequence.charAt(str, index2, endIndex);
            boolean illegal = false;
            boolean bl = isNegative2 = ch == '-';
            if ((isNegative2 || ch == '+') && (ch = JavaBigDecimalFromCharSequence.charAt(str, ++index2, endIndex)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            int integerPartIndex = index2;
            for (index2 = offset2; index2 < endIndex; ++index2) {
                int digits2;
                ch = str.charAt(index2);
                if (FastDoubleSwar.isDigit(ch)) {
                    significand = 10L * significand + (long)ch - 48L;
                    continue;
                }
                if (ch != '.') break;
                illegal |= decimalPointIndex >= 0;
                decimalPointIndex = index2;
                while (index2 < endIndex - 4 && (digits2 = FastDoubleSwar.tryToParseFourDigits(str, index2 + 1)) >= 0) {
                    significand = 10000L * significand + (long)digits2;
                    index2 += 4;
                }
            }
            int significandEndIndex = index2;
            if (decimalPointIndex < 0) {
                digitCount = significandEndIndex - integerPartIndex;
                decimalPointIndex = significandEndIndex;
                exponent2 = 0L;
            } else {
                digitCount = significandEndIndex - integerPartIndex - 1;
                exponent2 = decimalPointIndex - significandEndIndex + 1;
            }
            long expNumber = 0L;
            if ((ch | 0x20) == 101) {
                boolean isExponentNegative;
                exponentIndicatorIndex = index2++;
                ch = JavaBigDecimalFromCharSequence.charAt(str, index2, endIndex);
                boolean bl2 = isExponentNegative = ch == '-';
                if (isExponentNegative || ch == '+') {
                    ch = JavaBigDecimalFromCharSequence.charAt(str, ++index2, endIndex);
                }
                illegal |= !FastDoubleSwar.isDigit(ch);
                do {
                    if (expNumber >= Integer.MAX_VALUE) continue;
                    expNumber = 10L * expNumber + (long)ch - 48L;
                } while (FastDoubleSwar.isDigit(ch = JavaBigDecimalFromCharSequence.charAt(str, ++index2, endIndex)));
                if (isExponentNegative) {
                    expNumber = -expNumber;
                }
                exponent2 += expNumber;
            } else {
                exponentIndicatorIndex = endIndex;
            }
            JavaBigDecimalFromCharSequence.checkParsedBigDecimalBounds(illegal |= digitCount == 0, index2, endIndex, digitCount, exponent2);
            if (digitCount < 19) {
                return new BigDecimal(isNegative2 ? -significand : significand).scaleByPowerOfTen((int)exponent2);
            }
            return this.valueOfBigDecimalString(str, integerPartIndex, decimalPointIndex, decimalPointIndex + 1, exponentIndicatorIndex, isNegative2, (int)exponent2);
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e);
            throw nfe;
        }
    }

    BigDecimal parseBigDecimalStringWithManyDigits(CharSequence str, int offset2, int length2) {
        int exponentIndicatorIndex;
        long exponent2;
        int digitCountWithoutLeadingZeros;
        boolean isNegative2;
        int index2;
        int decimalPointIndex = -1;
        int nonZeroFractionalPartIndex = -1;
        int endIndex = offset2 + length2;
        char ch = JavaBigDecimalFromCharSequence.charAt(str, index2, endIndex);
        boolean illegal = false;
        boolean bl = isNegative2 = ch == '-';
        if ((isNegative2 || ch == '+') && (ch = JavaBigDecimalFromCharSequence.charAt(str, ++index2, endIndex)) == '\u0000') {
            throw new NumberFormatException("illegal syntax");
        }
        int integerPartIndex = index2;
        for (index2 = offset2; index2 < endIndex - 8 && FastDoubleSwar.isEightZeroes(str, index2); index2 += 8) {
        }
        while (index2 < endIndex && str.charAt(index2) == '0') {
            ++index2;
        }
        int nonZeroIntegerPartIndex = index2;
        while (index2 < endIndex - 8 && FastDoubleSwar.isEightDigits(str, index2)) {
            index2 += 8;
        }
        while (index2 < endIndex && FastDoubleSwar.isDigit(ch = str.charAt(index2))) {
            ++index2;
        }
        if (ch == '.') {
            decimalPointIndex = index2++;
            while (index2 < endIndex - 8 && FastDoubleSwar.isEightZeroes(str, index2)) {
                index2 += 8;
            }
            while (index2 < endIndex && str.charAt(index2) == '0') {
                ++index2;
            }
            nonZeroFractionalPartIndex = index2;
            while (index2 < endIndex - 8 && FastDoubleSwar.isEightDigits(str, index2)) {
                index2 += 8;
            }
            while (index2 < endIndex && FastDoubleSwar.isDigit(ch = str.charAt(index2))) {
                ++index2;
            }
        }
        int significandEndIndex = index2;
        if (decimalPointIndex < 0) {
            digitCountWithoutLeadingZeros = significandEndIndex - nonZeroIntegerPartIndex;
            decimalPointIndex = significandEndIndex;
            nonZeroFractionalPartIndex = significandEndIndex;
            exponent2 = 0L;
        } else {
            digitCountWithoutLeadingZeros = nonZeroIntegerPartIndex == decimalPointIndex ? significandEndIndex - nonZeroFractionalPartIndex : significandEndIndex - nonZeroIntegerPartIndex - 1;
            exponent2 = decimalPointIndex - significandEndIndex + 1;
        }
        long expNumber = 0L;
        if ((ch | 0x20) == 101) {
            boolean isExponentNegative;
            exponentIndicatorIndex = index2++;
            ch = JavaBigDecimalFromCharSequence.charAt(str, index2, endIndex);
            boolean bl2 = isExponentNegative = ch == '-';
            if (isExponentNegative || ch == '+') {
                ch = JavaBigDecimalFromCharSequence.charAt(str, ++index2, endIndex);
            }
            boolean bl3 = illegal = !FastDoubleSwar.isDigit(ch);
            do {
                if (expNumber >= Integer.MAX_VALUE) continue;
                expNumber = 10L * expNumber + (long)ch - 48L;
            } while (FastDoubleSwar.isDigit(ch = JavaBigDecimalFromCharSequence.charAt(str, ++index2, endIndex)));
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent2 += expNumber;
        } else {
            exponentIndicatorIndex = endIndex;
        }
        JavaBigDecimalFromCharSequence.checkParsedBigDecimalBounds(illegal |= integerPartIndex == decimalPointIndex && decimalPointIndex == exponentIndicatorIndex, index2, endIndex, digitCountWithoutLeadingZeros, exponent2);
        return this.valueOfBigDecimalString(str, nonZeroIntegerPartIndex, decimalPointIndex, nonZeroFractionalPartIndex, exponentIndicatorIndex, isNegative2, (int)exponent2);
    }

    BigDecimal valueOfBigDecimalString(CharSequence str, int integerPartIndex, int decimalPointIndex, int nonZeroFractionalPartIndex, int exponentIndicatorIndex, boolean isNegative2, int exponent2) {
        BigInteger significand;
        BigInteger integerPart;
        int fractionDigitsCount = exponentIndicatorIndex - decimalPointIndex - 1;
        int nonZeroFractionDigitsCount = exponentIndicatorIndex - nonZeroFractionalPartIndex;
        int integerDigitsCount = decimalPointIndex - integerPartIndex;
        NavigableMap<Integer, BigInteger> powersOfTen = null;
        if (integerDigitsCount > 0) {
            if (integerDigitsCount > 400) {
                powersOfTen = FastIntegerMath.createPowersOfTenFloor16Map();
                FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, integerPartIndex, decimalPointIndex);
                integerPart = ParseDigitsTaskCharSequence.parseDigitsRecursive(str, integerPartIndex, decimalPointIndex, powersOfTen, 400);
            } else {
                integerPart = ParseDigitsTaskCharSequence.parseDigitsIterative(str, integerPartIndex, decimalPointIndex);
            }
        } else {
            integerPart = BigInteger.ZERO;
        }
        if (fractionDigitsCount > 0) {
            BigInteger fractionalPart;
            if (nonZeroFractionDigitsCount > 400) {
                if (powersOfTen == null) {
                    powersOfTen = FastIntegerMath.createPowersOfTenFloor16Map();
                }
                FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, nonZeroFractionalPartIndex, exponentIndicatorIndex);
                fractionalPart = ParseDigitsTaskCharSequence.parseDigitsRecursive(str, nonZeroFractionalPartIndex, exponentIndicatorIndex, powersOfTen, 400);
            } else {
                fractionalPart = ParseDigitsTaskCharSequence.parseDigitsIterative(str, nonZeroFractionalPartIndex, exponentIndicatorIndex);
            }
            if (integerPart.signum() == 0) {
                significand = fractionalPart;
            } else {
                BigInteger integerFactor = FastIntegerMath.computePowerOfTen(powersOfTen, fractionDigitsCount);
                significand = FftMultiplier.multiply(integerPart, integerFactor).add(fractionalPart);
            }
        } else {
            significand = integerPart;
        }
        return new BigDecimal(isNegative2 ? significand.negate() : significand, -exponent2);
    }
}

