/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.FastDoubleMath;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import java.math.BigInteger;

class FftMultiplier {
    public static final double COS_0_25 = Math.cos(0.7853981633974483);
    public static final double SIN_0_25 = Math.sin(0.7853981633974483);
    private static final int FFT_THRESHOLD = 33220;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int ROOTS3_CACHE_SIZE = 20;
    private static final int ROOTS_CACHE2_SIZE = 20;
    private static final int TOOM_COOK_THRESHOLD = 1920;
    private static volatile ComplexVector[] ROOTS2_CACHE = new ComplexVector[20];
    private static volatile ComplexVector[] ROOTS3_CACHE = new ComplexVector[20];

    FftMultiplier() {
    }

    static int bitsPerFftPoint(int bitLen) {
        if (bitLen <= 9728) {
            return 19;
        }
        if (bitLen <= 18432) {
            return 18;
        }
        if (bitLen <= 69632) {
            return 17;
        }
        if (bitLen <= 262144) {
            return 16;
        }
        if (bitLen <= 983040) {
            return 15;
        }
        if (bitLen <= 0x380000) {
            return 14;
        }
        if (bitLen <= 0xD00000) {
            return 13;
        }
        if (bitLen <= 0x1800000) {
            return 12;
        }
        if (bitLen <= 0x5800000) {
            return 11;
        }
        if (bitLen <= 0x14000000) {
            return 10;
        }
        if (bitLen <= 0x48000000) {
            return 9;
        }
        return 8;
    }

    private static ComplexVector calculateRootsOfUnity(int n) {
        if (n == 1) {
            ComplexVector v = new ComplexVector(1);
            v.real(0, 1.0);
            v.imag(0, 0.0);
            return v;
        }
        ComplexVector roots = new ComplexVector(n);
        roots.set(0, 1.0, 0.0);
        double cos2 = COS_0_25;
        double sin2 = SIN_0_25;
        roots.set(n / 2, cos2, sin2);
        double angleTerm = 1.5707963267948966 / (double)n;
        for (int i2 = 1; i2 < n / 2; ++i2) {
            double angle = angleTerm * (double)i2;
            cos2 = Math.cos(angle);
            sin2 = Math.sin(angle);
            roots.set(i2, cos2, sin2);
            roots.set(n - i2, sin2, cos2);
        }
        return roots;
    }

    private static void fft(ComplexVector a, ComplexVector[] roots) {
        int s2;
        int n = a.length;
        int logN = 31 - Integer.numberOfLeadingZeros(n);
        MutableComplex a0 = new MutableComplex();
        MutableComplex a1 = new MutableComplex();
        MutableComplex a2 = new MutableComplex();
        MutableComplex a3 = new MutableComplex();
        MutableComplex omega1 = new MutableComplex();
        MutableComplex omega2 = new MutableComplex();
        for (s2 = logN; s2 >= 2; s2 -= 2) {
            ComplexVector rootsS = roots[s2 - 2];
            int m = 1 << s2;
            for (int i2 = 0; i2 < n; i2 += m) {
                for (int j = 0; j < m / 4; ++j) {
                    omega1.set(rootsS, j);
                    omega1.squareInto(omega2);
                    int idx0 = i2 + j;
                    int idx1 = i2 + j + m / 4;
                    int idx2 = i2 + j + m / 2;
                    int idx3 = i2 + j + m * 3 / 4;
                    a.addInto(idx0, a, idx1, a0);
                    a0.add(a, idx2);
                    a0.add(a, idx3);
                    a.subtractTimesIInto(idx0, a, idx1, a1);
                    a1.subtract(a, idx2);
                    a1.addTimesI(a, idx3);
                    a1.multiplyConjugate(omega1);
                    a.subtractInto(idx0, a, idx1, a2);
                    a2.add(a, idx2);
                    a2.subtract(a, idx3);
                    a2.multiplyConjugate(omega2);
                    a.addTimesIInto(idx0, a, idx1, a3);
                    a3.subtract(a, idx2);
                    a3.subtractTimesI(a, idx3);
                    a3.multiply(omega1);
                    a0.copyInto(a, idx0);
                    a1.copyInto(a, idx1);
                    a2.copyInto(a, idx2);
                    a3.copyInto(a, idx3);
                }
            }
        }
        if (s2 > 0) {
            for (int i3 = 0; i3 < n; i3 += 2) {
                a.copyInto(i3, a0);
                a.copyInto(i3 + 1, a1);
                a.add(i3, a1);
                a0.subtractInto(a1, a, i3 + 1);
            }
        }
    }

    private static void fft3(ComplexVector a0, ComplexVector a1, ComplexVector a2, int sign2, double scale2) {
        double omegaImag = (double)sign2 * -0.5 * Math.sqrt(3.0);
        for (int i2 = 0; i2 < a0.length; ++i2) {
            double a0Real = a0.real(i2) + a1.real(i2) + a2.real(i2);
            double a0Imag = a0.imag(i2) + a1.imag(i2) + a2.imag(i2);
            double c = omegaImag * (a2.imag(i2) - a1.imag(i2));
            double d = omegaImag * (a1.real(i2) - a2.real(i2));
            double e = 0.5 * (a1.real(i2) + a2.real(i2));
            double f = 0.5 * (a1.imag(i2) + a2.imag(i2));
            double a1Real = a0.real(i2) - e + c;
            double a1Imag = a0.imag(i2) + d - f;
            double a2Real = a0.real(i2) - e - c;
            double a2Imag = a0.imag(i2) - d - f;
            a0.real(i2, a0Real * scale2);
            a0.imag(i2, a0Imag * scale2);
            a1.real(i2, a1Real * scale2);
            a1.imag(i2, a1Imag * scale2);
            a2.real(i2, a2Real * scale2);
            a2.imag(i2, a2Imag * scale2);
        }
    }

    private static void fftMixedRadix(ComplexVector a, ComplexVector[] roots2, ComplexVector roots3) {
        int i2;
        int oneThird = a.length / 3;
        ComplexVector a0 = new ComplexVector(a, 0, oneThird);
        ComplexVector a1 = new ComplexVector(a, oneThird, oneThird * 2);
        ComplexVector a2 = new ComplexVector(a, oneThird * 2, a.length);
        FftMultiplier.fft3(a0, a1, a2, 1, 1.0);
        MutableComplex omega = new MutableComplex();
        for (i2 = 0; i2 < a.length / 4; ++i2) {
            omega.set(roots3, i2);
            a1.multiplyConjugate(i2, omega);
            a2.multiplyConjugate(i2, omega);
            a2.multiplyConjugate(i2, omega);
        }
        for (i2 = a.length / 4; i2 < oneThird; ++i2) {
            omega.set(roots3, i2 - a.length / 4);
            a1.multiplyConjugateTimesI(i2, omega);
            a2.multiplyConjugateTimesI(i2, omega);
            a2.multiplyConjugateTimesI(i2, omega);
        }
        FftMultiplier.fft(a0, roots2);
        FftMultiplier.fft(a1, roots2);
        FftMultiplier.fft(a2, roots2);
    }

    static BigInteger fromFftVector(ComplexVector fftVec, int signum, int bitsPerFftPoint) {
        assert (bitsPerFftPoint <= 25) : bitsPerFftPoint + " does not fit into an int with slack";
        int fftLen = (int)Math.min((long)fftVec.length, 0x80000000L / (long)bitsPerFftPoint + 1L);
        int magLen = (int)(8L * ((long)fftLen * (long)bitsPerFftPoint + 31L) / 32L);
        byte[] mag = new byte[magLen];
        int base = 1 << bitsPerFftPoint;
        int bitMask = base - 1;
        int bitPadding = 32 - bitsPerFftPoint;
        long carry = 0L;
        int bitLength = mag.length * 8;
        int bitIdx = bitLength - bitsPerFftPoint;
        int magComponent = 0;
        int prevIdx = Math.min(Math.max(0, bitIdx >> 3), mag.length - 4);
        for (int part = 0; part <= 1; ++part) {
            for (int fftIdx = 0; fftIdx < fftLen; ++fftIdx) {
                long fftElem = Math.round(fftVec.part(fftIdx, part)) + carry;
                carry = fftElem >> bitsPerFftPoint;
                int idx = Math.min(Math.max(0, bitIdx >> 3), mag.length - 4);
                magComponent >>>= prevIdx - idx << 3;
                int shift2 = bitPadding - bitIdx + (idx << 3);
                magComponent = (int)((long)magComponent | (fftElem & (long)bitMask) << shift2);
                FastDoubleSwar.writeIntBE(mag, idx, magComponent);
                prevIdx = idx;
                bitIdx -= bitsPerFftPoint;
            }
        }
        return new BigInteger(signum, mag);
    }

    private static ComplexVector[] getRootsOfUnity2(int logN) {
        ComplexVector[] roots = new ComplexVector[logN + 1];
        for (int i2 = logN; i2 >= 0; i2 -= 2) {
            if (i2 < 20) {
                if (ROOTS2_CACHE[i2] == null) {
                    FftMultiplier.ROOTS2_CACHE[i2] = FftMultiplier.calculateRootsOfUnity(1 << i2);
                }
                roots[i2] = ROOTS2_CACHE[i2];
                continue;
            }
            roots[i2] = FftMultiplier.calculateRootsOfUnity(1 << i2);
        }
        return roots;
    }

    private static ComplexVector getRootsOfUnity3(int logN) {
        if (logN < 20) {
            if (ROOTS3_CACHE[logN] == null) {
                FftMultiplier.ROOTS3_CACHE[logN] = FftMultiplier.calculateRootsOfUnity(3 << logN);
            }
            return ROOTS3_CACHE[logN];
        }
        return FftMultiplier.calculateRootsOfUnity(3 << logN);
    }

    private static void ifft(ComplexVector a, ComplexVector[] roots) {
        int n = a.length;
        int logN = 31 - Integer.numberOfLeadingZeros(n);
        MutableComplex a0 = new MutableComplex();
        MutableComplex a1 = new MutableComplex();
        MutableComplex a2 = new MutableComplex();
        MutableComplex a3 = new MutableComplex();
        MutableComplex b0 = new MutableComplex();
        MutableComplex b1 = new MutableComplex();
        MutableComplex b2 = new MutableComplex();
        MutableComplex b3 = new MutableComplex();
        int s2 = 1;
        if (logN % 2 != 0) {
            for (int i2 = 0; i2 < n; i2 += 2) {
                a.copyInto(i2 + 1, a2);
                a.copyInto(i2, a0);
                a.add(i2, a2);
                a0.subtractInto(a2, a, i2 + 1);
            }
            ++s2;
        }
        MutableComplex omega1 = new MutableComplex();
        MutableComplex omega2 = new MutableComplex();
        while (s2 <= logN) {
            ComplexVector rootsS = roots[s2 - 1];
            int m = 1 << s2 + 1;
            for (int i3 = 0; i3 < n; i3 += m) {
                for (int j = 0; j < m / 4; ++j) {
                    omega1.set(rootsS, j);
                    omega1.squareInto(omega2);
                    int idx0 = i3 + j;
                    int idx1 = i3 + j + m / 4;
                    int idx2 = i3 + j + m / 2;
                    int idx3 = i3 + j + m * 3 / 4;
                    a.copyInto(idx0, a0);
                    a.multiplyInto(idx1, omega1, a1);
                    a.multiplyInto(idx2, omega2, a2);
                    a.multiplyConjugateInto(idx3, omega1, a3);
                    a0.addInto(a1, b0);
                    b0.add(a2);
                    b0.add(a3);
                    a0.addTimesIInto(a1, b1);
                    b1.subtract(a2);
                    b1.subtractTimesI(a3);
                    a0.subtractInto(a1, b2);
                    b2.add(a2);
                    b2.subtract(a3);
                    a0.subtractTimesIInto(a1, b3);
                    b3.subtract(a2);
                    b3.addTimesI(a3);
                    b0.copyInto(a, idx0);
                    b1.copyInto(a, idx1);
                    b2.copyInto(a, idx2);
                    b3.copyInto(a, idx3);
                }
            }
            s2 += 2;
        }
        for (int i4 = 0; i4 < n; ++i4) {
            a.timesTwoToThe(i4, -logN);
        }
    }

    private static void ifftMixedRadix(ComplexVector a, ComplexVector[] roots2, ComplexVector roots3) {
        int i2;
        int oneThird = a.length / 3;
        ComplexVector a0 = new ComplexVector(a, 0, oneThird);
        ComplexVector a1 = new ComplexVector(a, oneThird, oneThird * 2);
        ComplexVector a2 = new ComplexVector(a, oneThird * 2, a.length);
        FftMultiplier.ifft(a0, roots2);
        FftMultiplier.ifft(a1, roots2);
        FftMultiplier.ifft(a2, roots2);
        MutableComplex omega = new MutableComplex();
        for (i2 = 0; i2 < a.length / 4; ++i2) {
            omega.set(roots3, i2);
            a1.multiply(i2, omega);
            a2.multiply(i2, omega);
            a2.multiply(i2, omega);
        }
        for (i2 = a.length / 4; i2 < oneThird; ++i2) {
            omega.set(roots3, i2 - a.length / 4);
            a1.multiplyByIAnd(i2, omega);
            a2.multiplyByIAnd(i2, omega);
            a2.multiplyByIAnd(i2, omega);
        }
        FftMultiplier.fft3(a0, a1, a2, -1, 0.3333333333333333);
    }

    static BigInteger multiply(BigInteger a, BigInteger b2) {
        int ylen;
        assert (a != null) : "a==null";
        assert (b2 != null) : "b==null";
        if (b2.signum() == 0 || a.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (b2 == a) {
            return FftMultiplier.square(b2);
        }
        int xlen = a.bitLength();
        if ((long)xlen + (long)(ylen = b2.bitLength()) > 0x80000000L) {
            throw new ArithmeticException("BigInteger would overflow supported range");
        }
        if (xlen > 1920 && ylen > 1920 && (xlen > 33220 || ylen > 33220)) {
            return FftMultiplier.multiplyFft(a, b2);
        }
        return a.multiply(b2);
    }

    static BigInteger multiplyFft(BigInteger a, BigInteger b2) {
        int logFFTLen;
        int fftLen2;
        int fftLen3;
        int bitsPerPoint;
        byte[] bMag;
        int signum = a.signum() * b2.signum();
        byte[] aMag = (a.signum() < 0 ? a.negate() : a).toByteArray();
        int bitLen = Math.max(aMag.length, (bMag = (b2.signum() < 0 ? b2.negate() : b2).toByteArray()).length) * 8;
        int fftLen = (bitLen + (bitsPerPoint = FftMultiplier.bitsPerFftPoint(bitLen)) - 1) / bitsPerPoint + 1;
        if (fftLen < (fftLen3 = (fftLen2 = 1 << (logFFTLen = 32 - Integer.numberOfLeadingZeros(fftLen - 1))) * 3 / 4) && logFFTLen > 3) {
            ComplexVector[] roots2 = FftMultiplier.getRootsOfUnity2(logFFTLen - 2);
            ComplexVector weights = FftMultiplier.getRootsOfUnity3(logFFTLen - 2);
            ComplexVector twiddles = FftMultiplier.getRootsOfUnity3(logFFTLen - 4);
            ComplexVector aVec = FftMultiplier.toFftVector(aMag, fftLen3, bitsPerPoint);
            aVec.applyWeights(weights);
            FftMultiplier.fftMixedRadix(aVec, roots2, twiddles);
            ComplexVector bVec = FftMultiplier.toFftVector(bMag, fftLen3, bitsPerPoint);
            bVec.applyWeights(weights);
            FftMultiplier.fftMixedRadix(bVec, roots2, twiddles);
            aVec.multiplyPointwise(bVec);
            FftMultiplier.ifftMixedRadix(aVec, roots2, twiddles);
            aVec.applyInverseWeights(weights);
            return FftMultiplier.fromFftVector(aVec, signum, bitsPerPoint);
        }
        ComplexVector[] roots = FftMultiplier.getRootsOfUnity2(logFFTLen);
        ComplexVector aVec = FftMultiplier.toFftVector(aMag, fftLen2, bitsPerPoint);
        aVec.applyWeights(roots[logFFTLen]);
        FftMultiplier.fft(aVec, roots);
        ComplexVector bVec = FftMultiplier.toFftVector(bMag, fftLen2, bitsPerPoint);
        bVec.applyWeights(roots[logFFTLen]);
        FftMultiplier.fft(bVec, roots);
        aVec.multiplyPointwise(bVec);
        FftMultiplier.ifft(aVec, roots);
        aVec.applyInverseWeights(roots[logFFTLen]);
        return FftMultiplier.fromFftVector(aVec, signum, bitsPerPoint);
    }

    static BigInteger square(BigInteger a) {
        if (a.signum() == 0) {
            return BigInteger.ZERO;
        }
        return a.bitLength() < 33220 ? a.multiply(a) : FftMultiplier.squareFft(a);
    }

    static BigInteger squareFft(BigInteger a) {
        int logFFTLen;
        int fftLen2;
        int fftLen3;
        int bitsPerPoint;
        byte[] mag = a.toByteArray();
        int bitLen = mag.length * 8;
        int fftLen = (bitLen + (bitsPerPoint = FftMultiplier.bitsPerFftPoint(bitLen)) - 1) / bitsPerPoint + 1;
        if (fftLen < (fftLen3 = (fftLen2 = 1 << (logFFTLen = 32 - Integer.numberOfLeadingZeros(fftLen - 1))) * 3 / 4)) {
            fftLen = fftLen3;
            ComplexVector vec = FftMultiplier.toFftVector(mag, fftLen, bitsPerPoint);
            ComplexVector[] roots2 = FftMultiplier.getRootsOfUnity2(logFFTLen - 2);
            ComplexVector weights = FftMultiplier.getRootsOfUnity3(logFFTLen - 2);
            ComplexVector twiddles = FftMultiplier.getRootsOfUnity3(logFFTLen - 4);
            vec.applyWeights(weights);
            FftMultiplier.fftMixedRadix(vec, roots2, twiddles);
            vec.squarePointwise();
            FftMultiplier.ifftMixedRadix(vec, roots2, twiddles);
            vec.applyInverseWeights(weights);
            return FftMultiplier.fromFftVector(vec, 1, bitsPerPoint);
        }
        fftLen = fftLen2;
        ComplexVector vec = FftMultiplier.toFftVector(mag, fftLen, bitsPerPoint);
        ComplexVector[] roots = FftMultiplier.getRootsOfUnity2(logFFTLen);
        vec.applyWeights(roots[logFFTLen]);
        FftMultiplier.fft(vec, roots);
        vec.squarePointwise();
        FftMultiplier.ifft(vec, roots);
        vec.applyInverseWeights(roots[logFFTLen]);
        return FftMultiplier.fromFftVector(vec, 1, bitsPerPoint);
    }

    static ComplexVector toFftVector(byte[] mag, int fftLen, int bitsPerFftPoint) {
        assert (bitsPerFftPoint <= 25) : bitsPerFftPoint + " does not fit into an int with slack";
        ComplexVector fftVec = new ComplexVector(fftLen);
        if (mag.length < 4) {
            byte[] paddedMag = new byte[4];
            System.arraycopy(mag, 0, paddedMag, 4 - mag.length, mag.length);
            mag = paddedMag;
        }
        int base = 1 << bitsPerFftPoint;
        int halfBase = base / 2;
        int bitMask = base - 1;
        int bitPadding = 32 - bitsPerFftPoint;
        int bitLength = mag.length * 8;
        int carry = 0;
        int fftIdx = 0;
        for (int bitIdx = bitLength - bitsPerFftPoint; bitIdx > -bitsPerFftPoint; bitIdx -= bitsPerFftPoint) {
            int idx = Math.min(Math.max(0, bitIdx >> 3), mag.length - 4);
            int shift2 = bitPadding - bitIdx + (idx << 3);
            int fftPoint = FastDoubleSwar.readIntBE(mag, idx) >>> shift2 & bitMask;
            carry = halfBase - (fftPoint += carry) >>> 31;
            fftVec.real(fftIdx, fftPoint -= base & -carry);
            ++fftIdx;
        }
        if (carry > 0) {
            fftVec.real(fftIdx, carry);
        }
        return fftVec;
    }

    static final class ComplexVector {
        private static final int COMPLEX_SIZE_SHIFT = 1;
        static final int IMAG = 1;
        static final int REAL = 0;
        private final double[] a;
        private final int length;
        private final int offset;

        ComplexVector(int length2) {
            this.a = new double[length2 << 1];
            this.length = length2;
            this.offset = 0;
        }

        ComplexVector(ComplexVector c, int from, int to) {
            this.length = to - from;
            this.a = c.a;
            this.offset = from << 1;
        }

        void add(int idxa, MutableComplex c) {
            int n = this.realIdx(idxa);
            this.a[n] = this.a[n] + c.real;
            int n2 = this.imagIdx(idxa);
            this.a[n2] = this.a[n2] + c.imag;
        }

        void addInto(int idxa, ComplexVector c, int idxc, MutableComplex destination) {
            destination.real = this.a[this.realIdx(idxa)] + c.real(idxc);
            destination.imag = this.a[this.imagIdx(idxa)] + c.imag(idxc);
        }

        void addTimesIInto(int idxa, ComplexVector c, int idxc, MutableComplex destination) {
            destination.real = this.a[this.realIdx(idxa)] - c.imag(idxc);
            destination.imag = this.a[this.imagIdx(idxa)] + c.real(idxc);
        }

        void applyInverseWeights(ComplexVector weights) {
            int offw = weights.offset;
            double[] w = weights.a;
            int end2 = this.offset + this.length << 1;
            for (int offa = this.offset; offa < end2; offa += 2) {
                double real2 = this.a[offa + 0];
                double imag = this.a[offa + 1];
                this.a[offa] = FastDoubleSwar.fma(real2, w[offw + 0], imag * w[offw + 1]);
                this.a[offa + 1] = FastDoubleSwar.fma(-real2, w[offw + 1], imag * w[offw + 0]);
                offw += 2;
            }
        }

        void applyWeights(ComplexVector weights) {
            int offw = weights.offset;
            double[] w = weights.a;
            int end2 = this.offset + this.length << 1;
            for (int offa = this.offset; offa < end2; offa += 2) {
                double real2 = this.a[offa + 0];
                this.a[offa + 0] = real2 * w[offw + 0];
                this.a[offa + 1] = real2 * w[offw + 1];
                offw += 2;
            }
        }

        void copyInto(int idxa, MutableComplex destination) {
            destination.real = this.a[this.realIdx(idxa)];
            destination.imag = this.a[this.imagIdx(idxa)];
        }

        double imag(int idxa) {
            return this.a[(idxa << 1) + this.offset + 1];
        }

        void imag(int idxa, double value2) {
            this.a[(idxa << 1) + this.offset + 1] = value2;
        }

        private int imagIdx(int idxa) {
            return (idxa << 1) + this.offset + 1;
        }

        void multiply(int idxa, MutableComplex c) {
            int ri = this.realIdx(idxa);
            int ii = this.imagIdx(idxa);
            double real2 = this.a[ri];
            double imag = this.a[ii];
            this.a[ri] = FastDoubleSwar.fma(real2, c.real, -imag * c.imag);
            this.a[ii] = FastDoubleSwar.fma(real2, c.imag, imag * c.real);
        }

        void multiplyByIAnd(int idxa, MutableComplex c) {
            int ri = this.realIdx(idxa);
            int ii = this.imagIdx(idxa);
            double real2 = this.a[ri];
            double imag = this.a[ii];
            this.a[ri] = FastDoubleSwar.fma(-real2, c.imag, -imag * c.real);
            this.a[ii] = FastDoubleSwar.fma(real2, c.real, -imag * c.imag);
        }

        void multiplyConjugate(int idxa, MutableComplex c) {
            int ri = this.realIdx(idxa);
            int ii = this.imagIdx(idxa);
            double real2 = this.a[ri];
            double imag = this.a[ii];
            this.a[ri] = FastDoubleSwar.fma(real2, c.real, imag * c.imag);
            this.a[ii] = FastDoubleSwar.fma(-real2, c.imag, imag * c.real);
        }

        void multiplyConjugateInto(int idxa, MutableComplex c, MutableComplex destination) {
            double real2 = this.a[this.realIdx(idxa)];
            double imag = this.a[this.imagIdx(idxa)];
            destination.real = FastDoubleSwar.fma(real2, c.real, imag * c.imag);
            destination.imag = FastDoubleSwar.fma(-real2, c.imag, imag * c.real);
        }

        void multiplyConjugateTimesI(int idxa, MutableComplex c) {
            int ri = this.realIdx(idxa);
            int ii = this.imagIdx(idxa);
            double real2 = this.a[ri];
            double imag = this.a[ii];
            this.a[ri] = FastDoubleSwar.fma(-real2, c.imag, imag * c.real);
            this.a[ii] = FastDoubleSwar.fma(-real2, c.real, -imag * c.imag);
        }

        void multiplyInto(int idxa, MutableComplex c, MutableComplex destination) {
            double real2 = this.a[this.realIdx(idxa)];
            double imag = this.a[this.imagIdx(idxa)];
            destination.real = FastDoubleSwar.fma(real2, c.real, -imag * c.imag);
            destination.imag = FastDoubleSwar.fma(real2, c.imag, imag * c.real);
        }

        void multiplyPointwise(ComplexVector cvec) {
            int offc = cvec.offset;
            double[] c = cvec.a;
            int end2 = this.offset + this.length << 1;
            for (int offa = this.offset; offa < end2; offa += 2) {
                double real2 = this.a[offa + 0];
                double imag = this.a[offa + 1];
                double creal = c[offc + 0];
                double cimag = c[offc + 1];
                this.a[offa + 0] = FastDoubleSwar.fma(real2, creal, -imag * cimag);
                this.a[offa + 1] = FastDoubleSwar.fma(real2, cimag, imag * creal);
                offc += 2;
            }
        }

        double part(int idxa, int part) {
            return this.a[(idxa << 1) + part];
        }

        double real(int idxa) {
            return this.a[(idxa << 1) + this.offset];
        }

        void real(int idxa, double value2) {
            this.a[(idxa << 1) + this.offset] = value2;
        }

        private int realIdx(int idxa) {
            return (idxa << 1) + this.offset;
        }

        void set(int idxa, double real2, double imag) {
            int idx = this.realIdx(idxa);
            this.a[idx] = real2;
            this.a[idx + 1] = imag;
        }

        void squarePointwise() {
            int end2 = this.offset + this.length << 1;
            for (int offa = this.offset; offa < end2; offa += 2) {
                double real2 = this.a[offa + 0];
                double imag = this.a[offa + 1];
                this.a[offa + 0] = FastDoubleSwar.fma(real2, real2, -imag * imag);
                this.a[offa + 1] = 2.0 * real2 * imag;
            }
        }

        void subtractInto(int idxa, ComplexVector c, int idxc, MutableComplex destination) {
            destination.real = this.a[this.realIdx(idxa)] - c.real(idxc);
            destination.imag = this.a[this.imagIdx(idxa)] - c.imag(idxc);
        }

        void subtractTimesIInto(int idxa, ComplexVector c, int idxc, MutableComplex destination) {
            destination.real = this.a[this.realIdx(idxa)] + c.imag(idxc);
            destination.imag = this.a[this.imagIdx(idxa)] - c.real(idxc);
        }

        void timesTwoToThe(int idxa, int n) {
            int ri = this.realIdx(idxa);
            int ii = this.imagIdx(idxa);
            double real2 = this.a[ri];
            double imag = this.a[ii];
            this.a[ri] = FastDoubleMath.fastScalb(real2, n);
            this.a[ii] = FastDoubleMath.fastScalb(imag, n);
        }
    }

    static final class MutableComplex {
        double real;
        double imag;

        MutableComplex() {
        }

        void add(MutableComplex c) {
            this.real += c.real;
            this.imag += c.imag;
        }

        void add(ComplexVector c, int idxc) {
            this.real += c.real(idxc);
            this.imag += c.imag(idxc);
        }

        void addInto(MutableComplex c, MutableComplex destination) {
            destination.real = this.real + c.real;
            destination.imag = this.imag + c.imag;
        }

        void addTimesI(MutableComplex c) {
            this.real -= c.imag;
            this.imag += c.real;
        }

        void addTimesI(ComplexVector c, int idxc) {
            this.real -= c.imag(idxc);
            this.imag += c.real(idxc);
        }

        void addTimesIInto(MutableComplex c, MutableComplex destination) {
            destination.real = this.real - c.imag;
            destination.imag = this.imag + c.real;
        }

        void copyInto(ComplexVector c, int idxc) {
            c.real(idxc, this.real);
            c.imag(idxc, this.imag);
        }

        void multiply(MutableComplex c) {
            double temp = this.real;
            this.real = FastDoubleSwar.fma(temp, c.real, -this.imag * c.imag);
            this.imag = FastDoubleSwar.fma(temp, c.imag, this.imag * c.real);
        }

        void multiplyConjugate(MutableComplex c) {
            double temp = this.real;
            this.real = FastDoubleSwar.fma(temp, c.real, this.imag * c.imag);
            this.imag = FastDoubleSwar.fma(-temp, c.imag, this.imag * c.real);
        }

        void set(ComplexVector c, int idxc) {
            this.real = c.real(idxc);
            this.imag = c.imag(idxc);
        }

        void squareInto(MutableComplex destination) {
            destination.real = FastDoubleSwar.fma(this.real, this.real, -this.imag * this.imag);
            destination.imag = 2.0 * this.real * this.imag;
        }

        void subtract(MutableComplex c) {
            this.real -= c.real;
            this.imag -= c.imag;
        }

        void subtract(ComplexVector c, int idxc) {
            this.real -= c.real(idxc);
            this.imag -= c.imag(idxc);
        }

        void subtractInto(MutableComplex c, MutableComplex destination) {
            destination.real = this.real - c.real;
            destination.imag = this.imag - c.imag;
        }

        void subtractInto(MutableComplex c, ComplexVector destination, int idxd) {
            destination.real(idxd, this.real - c.real);
            destination.imag(idxd, this.imag - c.imag);
        }

        void subtractTimesI(MutableComplex c) {
            this.real += c.imag;
            this.imag -= c.real;
        }

        void subtractTimesI(ComplexVector c, int idxc) {
            this.real += c.imag(idxc);
            this.imag -= c.real(idxc);
        }

        void subtractTimesIInto(MutableComplex c, MutableComplex destination) {
            destination.real = this.real + c.imag;
            destination.imag = this.imag - c.real;
        }
    }
}

