/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

class FastDoubleSwar {
    private static final VarHandle readLongLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN).withInvokeExactBehavior();
    private static final VarHandle readIntLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN).withInvokeExactBehavior();
    private static final VarHandle readIntBE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN).withInvokeExactBehavior();
    private static final VarHandle readLongBE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN).withInvokeExactBehavior();

    FastDoubleSwar() {
    }

    protected static boolean isDigit(char c) {
        return (char)(c - 48) < '\n';
    }

    protected static boolean isDigit(byte c) {
        return (char)(c - 48) < '\n';
    }

    public static boolean isEightDigits(byte[] a, int offset2) {
        return FastDoubleSwar.isEightDigitsUtf8(readLongLE.get(a, offset2));
    }

    public static boolean isEightDigits(char[] a, int offset2) {
        long first2 = (long)a[offset2] | (long)a[offset2 + 1] << 16 | (long)a[offset2 + 2] << 32 | (long)a[offset2 + 3] << 48;
        long second2 = (long)a[offset2 + 4] | (long)a[offset2 + 5] << 16 | (long)a[offset2 + 6] << 32 | (long)a[offset2 + 7] << 48;
        return FastDoubleSwar.isEightDigitsUtf16(first2, second2);
    }

    public static boolean isEightDigits(CharSequence a, int offset2) {
        boolean success = true;
        for (int i2 = 0; i2 < 8; ++i2) {
            char ch = a.charAt(i2 + offset2);
            success &= FastDoubleSwar.isDigit(ch);
        }
        return success;
    }

    public static boolean isEightDigitsUtf16(long first2, long second2) {
        long fval = first2 - 0x30003000300030L;
        long fpre = first2 + 0x46004600460046L | fval;
        long sval = second2 - 0x30003000300030L;
        long spre = second2 + 0x46004600460046L | sval;
        return ((fpre | spre) & 0xFF80FF80FF80FF80L) == 0L;
    }

    public static boolean isEightDigitsUtf8(long chunk2) {
        long val = chunk2 - 0x3030303030303030L;
        long predicate = (chunk2 + 0x4646464646464646L | val) & 0x8080808080808080L;
        return predicate == 0L;
    }

    public static boolean isEightZeroes(byte[] a, int offset2) {
        return FastDoubleSwar.isEightZeroesUtf8(readLongLE.get(a, offset2));
    }

    public static boolean isEightZeroes(CharSequence a, int offset2) {
        boolean success = true;
        for (int i2 = 0; i2 < 8; ++i2) {
            success &= '0' == a.charAt(i2 + offset2);
        }
        return success;
    }

    public static boolean isEightZeroes(char[] a, int offset2) {
        long first2 = (long)a[offset2] | (long)a[offset2 + 1] << 16 | (long)a[offset2 + 2] << 32 | (long)a[offset2 + 3] << 48;
        long second2 = (long)a[offset2 + 4] | (long)a[offset2 + 5] << 16 | (long)a[offset2 + 6] << 32 | (long)a[offset2 + 7] << 48;
        return FastDoubleSwar.isEightZeroesUtf16(first2, second2);
    }

    public static boolean isEightZeroesUtf16(long first2, long second2) {
        return first2 == 0x30003000300030L && second2 == 0x30003000300030L;
    }

    public static boolean isEightZeroesUtf8(long chunk2) {
        return chunk2 == 0x3030303030303030L;
    }

    public static int readIntBE(byte[] a, int offset2) {
        return readIntBE.get(a, offset2);
    }

    public static long readLongBE(byte[] a, int offset2) {
        return readLongBE.get(a, offset2);
    }

    public static long readLongLE(byte[] a, int offset2) {
        return readLongLE.get(a, offset2);
    }

    public static int tryToParseEightDigits(char[] a, int offset2) {
        long first2 = (long)a[offset2] | (long)a[offset2 + 1] << 16 | (long)a[offset2 + 2] << 32 | (long)a[offset2 + 3] << 48;
        long second2 = (long)a[offset2 + 4] | (long)a[offset2 + 5] << 16 | (long)a[offset2 + 6] << 32 | (long)a[offset2 + 7] << 48;
        return FastDoubleSwar.tryToParseEightDigitsUtf16(first2, second2);
    }

    public static int tryToParseEightDigits(byte[] a, int offset2) {
        return FastDoubleSwar.tryToParseEightDigitsUtf8(readLongLE.get(a, offset2));
    }

    public static int tryToParseEightDigits(CharSequence str, int offset2) {
        long first2 = (long)str.charAt(offset2) | (long)str.charAt(offset2 + 1) << 16 | (long)str.charAt(offset2 + 2) << 32 | (long)str.charAt(offset2 + 3) << 48;
        long second2 = (long)str.charAt(offset2 + 4) | (long)str.charAt(offset2 + 5) << 16 | (long)str.charAt(offset2 + 6) << 32 | (long)str.charAt(offset2 + 7) << 48;
        return FastDoubleSwar.tryToParseEightDigitsUtf16(first2, second2);
    }

    public static int tryToParseEightDigitsUtf16(long first2, long second2) {
        long fval = first2 - 0x30003000300030L;
        long fpre = first2 + 0x46004600460046L | fval;
        long sval = second2 - 0x30003000300030L;
        long spre = second2 + 0x46004600460046L | sval;
        if (((fpre | spre) & 0xFF80FF80FF80FF80L) != 0L) {
            return -1;
        }
        return (int)(sval * 281475406208040961L >>> 48) + (int)(fval * 281475406208040961L >>> 48) * 10000;
    }

    public static int tryToParseEightDigitsUtf8(byte[] a, int offset2) {
        return FastDoubleSwar.tryToParseEightDigitsUtf8(readLongLE.get(a, offset2));
    }

    public static int tryToParseEightDigitsUtf8(long chunk2) {
        long val = chunk2 - 0x3030303030303030L;
        long predicate = (chunk2 + 0x4646464646464646L | val) & 0x8080808080808080L;
        if (predicate != 0L) {
            return -1;
        }
        long mask = 0xFF000000FFL;
        long mul1 = 4294967296000100L;
        long mul2 = 42949672960001L;
        val = val * 10L + (val >>> 8);
        val = (val & mask) * mul1 + (val >>> 16 & mask) * mul2 >>> 32;
        return (int)val;
    }

    public static long tryToParseEightHexDigits(CharSequence str, int offset2) {
        long first2 = (long)str.charAt(offset2) << 48 | (long)str.charAt(offset2 + 1) << 32 | (long)str.charAt(offset2 + 2) << 16 | (long)str.charAt(offset2 + 3);
        long second2 = (long)str.charAt(offset2 + 4) << 48 | (long)str.charAt(offset2 + 5) << 32 | (long)str.charAt(offset2 + 6) << 16 | (long)str.charAt(offset2 + 7);
        return FastDoubleSwar.tryToParseEightHexDigitsUtf16(first2, second2);
    }

    public static long tryToParseEightHexDigits(char[] chars2, int offset2) {
        long first2 = (long)chars2[offset2] << 48 | (long)chars2[offset2 + 1] << 32 | (long)chars2[offset2 + 2] << 16 | (long)chars2[offset2 + 3];
        long second2 = (long)chars2[offset2 + 4] << 48 | (long)chars2[offset2 + 5] << 32 | (long)chars2[offset2 + 6] << 16 | (long)chars2[offset2 + 7];
        return FastDoubleSwar.tryToParseEightHexDigitsUtf16(first2, second2);
    }

    public static long tryToParseEightHexDigits(byte[] a, int offset2) {
        return FastDoubleSwar.tryToParseEightHexDigitsUtf8(readLongBE.get(a, offset2));
    }

    public static long tryToParseEightHexDigitsUtf16(long first2, long second2) {
        if (((first2 | second2) & 0xFF80FF80FF80FF80L) != 0L) {
            return -1L;
        }
        long utf8Bytes = Long.compress(first2, 0xFF00FF00FF00FFL) << 32 | Long.compress(second2, 0xFF00FF00FF00FFL);
        return FastDoubleSwar.tryToParseEightHexDigitsUtf8(utf8Bytes);
    }

    public static long tryToParseEightHexDigitsUtf8(long chunk2) {
        long ge_0 = chunk2 + 0x5050505050505050L;
        long le_9 = 0x3A3A3A3A3A3A3A3AL + (chunk2 ^ 0x7F7F7F7F7F7F7F7FL);
        long lowerCaseChunk = chunk2 | 0x2020202020202020L;
        long ge_a = lowerCaseChunk + 0x1F1F1F1F1F1F1F1FL;
        long le_f = 0x6767676767676767L + (lowerCaseChunk ^ 0x7F7F7F7F7F7F7F7FL);
        if (((ge_0 & le_9 ^ (ge_a &= 0x8080808080808080L) & le_f) & 0x8080808080808080L) != -9187201950435737472L) {
            return -1L;
        }
        long ge_a_mask = (ge_a >>> 7) * 255L;
        long vec = lowerCaseChunk - 0x3030303030303030L;
        long v = vec & (ge_a_mask ^ 0xFFFFFFFFFFFFFFFFL) | vec - (0x2727272727272727L & ge_a_mask);
        return Long.compress(v, 0xF0F0F0F0F0F0F0FL);
    }

    public static int tryToParseFourDigits(char[] a, int offset2) {
        long first2 = (long)a[offset2] | (long)a[offset2 + 1] << 16 | (long)a[offset2 + 2] << 32 | (long)a[offset2 + 3] << 48;
        return FastDoubleSwar.tryToParseFourDigitsUtf16(first2);
    }

    public static int tryToParseFourDigits(CharSequence str, int offset2) {
        long first2 = (long)str.charAt(offset2) | (long)str.charAt(offset2 + 1) << 16 | (long)str.charAt(offset2 + 2) << 32 | (long)str.charAt(offset2 + 3) << 48;
        return FastDoubleSwar.tryToParseFourDigitsUtf16(first2);
    }

    public static int tryToParseFourDigits(byte[] a, int offset2) {
        return FastDoubleSwar.tryToParseFourDigitsUtf8(readIntLE.get(a, offset2));
    }

    public static int tryToParseFourDigitsUtf16(long first2) {
        long fval = first2 - 0x30003000300030L;
        long fpre = first2 + 0x46004600460046L | fval;
        if ((fpre & 0xFF80FF80FF80FF80L) != 0L) {
            return -1;
        }
        return (int)(fval * 281475406208040961L >>> 48);
    }

    public static int tryToParseFourDigitsUtf8(int chunk2) {
        int val = chunk2 - 0x30303030;
        int predicate = (chunk2 + 0x46464646 | val) & 0x80808080;
        if ((long)predicate != 0L) {
            return -1;
        }
        val = val * 2561 >>> 8;
        val = (val & 0xFF) * 100 + ((val & 0xFF0000) >> 16);
        return val;
    }

    public static int tryToParseUpTo7Digits(byte[] str, int from, int to) {
        int result2 = 0;
        boolean success = true;
        while (from < to) {
            byte ch = str[from];
            success &= FastDoubleSwar.isDigit(ch);
            result2 = 10 * result2 + ch - 48;
            ++from;
        }
        return success ? result2 : -1;
    }

    public static int tryToParseUpTo7Digits(char[] str, int from, int to) {
        int result2 = 0;
        boolean success = true;
        while (from < to) {
            char ch = str[from];
            success &= FastDoubleSwar.isDigit(ch);
            result2 = 10 * result2 + ch - 48;
            ++from;
        }
        return success ? result2 : -1;
    }

    public static int tryToParseUpTo7Digits(CharSequence str, int from, int to) {
        int result2 = 0;
        boolean success = true;
        while (from < to) {
            char ch = str.charAt(from);
            success &= FastDoubleSwar.isDigit(ch);
            result2 = 10 * result2 + ch - 48;
            ++from;
        }
        return success ? result2 : -1;
    }

    public static void writeIntBE(byte[] a, int offset2, int value2) {
        readIntBE.set(a, offset2, value2);
    }

    public static void writeLongBE(byte[] a, int offset2, long value2) {
        readLongBE.set(a, offset2, value2);
    }

    public static double fma(double a, double b2, double c) {
        return Math.fma(a, b2, c);
    }
}

