/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusUtil {
    StatusManager sm;

    public StatusUtil(StatusManager sm) {
        this.sm = sm;
    }

    public StatusUtil(Context context) {
        this.sm = context.getStatusManager();
    }

    public static boolean contextHasStatusListener(Context context) {
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            return false;
        }
        List<StatusListener> listeners = sm.getCopyOfStatusListenerList();
        return listeners != null && listeners.size() != 0;
    }

    public static List<Status> filterStatusListByTimeThreshold(List<Status> rawList, long threshold) {
        ArrayList<Status> filteredList = new ArrayList<Status>();
        for (Status s2 : rawList) {
            if (s2.getTimestamp() < threshold) continue;
            filteredList.add(s2);
        }
        return filteredList;
    }

    public void addStatus(Status status2) {
        if (this.sm != null) {
            this.sm.add(status2);
        }
    }

    public void addInfo(Object caller2, String msg) {
        this.addStatus(new InfoStatus(msg, caller2));
    }

    public void addWarn(Object caller2, String msg) {
        this.addStatus(new WarnStatus(msg, caller2));
    }

    public void addError(Object caller2, String msg, Throwable t) {
        this.addStatus(new ErrorStatus(msg, caller2, t));
    }

    public boolean hasXMLParsingErrors(long threshold) {
        return this.containsMatch(threshold, 2, "XML_PARSING");
    }

    public boolean noXMLParsingErrorsOccurred(long threshold) {
        return !this.hasXMLParsingErrors(threshold);
    }

    public int getHighestLevel(long threshold) {
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        int maxLevel = 0;
        for (Status s2 : filteredList) {
            if (s2.getLevel() <= maxLevel) continue;
            maxLevel = s2.getLevel();
        }
        return maxLevel;
    }

    public boolean isErrorFree(long threshold) {
        return this.getHighestLevel(threshold) < 2;
    }

    public boolean isWarningOrErrorFree(long threshold) {
        return 1 > this.getHighestLevel(threshold);
    }

    public boolean containsMatch(long threshold, int level2, String regex) {
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        Pattern p2 = Pattern.compile(regex);
        for (Status status2 : filteredList) {
            String msg;
            Matcher matcher;
            if (level2 != status2.getLevel() || !(matcher = p2.matcher(msg = status2.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMatch(int level2, String regex) {
        return this.containsMatch(0L, level2, regex);
    }

    public boolean containsMatch(String regex) {
        Pattern p2 = Pattern.compile(regex);
        for (Status status2 : this.sm.getCopyOfStatusList()) {
            String msg = status2.getMessage();
            Matcher matcher = p2.matcher(msg);
            if (!matcher.lookingAt()) continue;
            return true;
        }
        return false;
    }

    public int levelCount(int level2, long threshold) {
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        int count2 = 0;
        for (Status status2 : filteredList) {
            if (status2.getLevel() != level2) continue;
            ++count2;
        }
        return count2;
    }

    public int matchCount(String regex) {
        int count2 = 0;
        Pattern p2 = Pattern.compile(regex);
        for (Status status2 : this.sm.getCopyOfStatusList()) {
            String msg = status2.getMessage();
            Matcher matcher = p2.matcher(msg);
            if (!matcher.lookingAt()) continue;
            ++count2;
        }
        return count2;
    }

    public boolean containsException(Class<?> exceptionType) {
        return this.containsException(exceptionType, null);
    }

    public boolean containsException(Class<?> exceptionType, String msgRegex) {
        for (Status status2 : this.sm.getCopyOfStatusList()) {
            for (Throwable t = status2.getThrowable(); t != null; t = t.getCause()) {
                if (!t.getClass().getName().equals(exceptionType.getName())) continue;
                if (msgRegex == null) {
                    return true;
                }
                if (!this.checkRegexMatch(t.getMessage(), msgRegex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkRegexMatch(String message2, String msgRegex) {
        Pattern p2 = Pattern.compile(msgRegex);
        Matcher matcher = p2.matcher(message2);
        return matcher.lookingAt();
    }

    public long timeOfLastReset() {
        List<Status> statusList = this.sm.getCopyOfStatusList();
        if (statusList == null) {
            return -1L;
        }
        int len = statusList.size();
        for (int i2 = len - 1; i2 >= 0; --i2) {
            Status s2 = statusList.get(i2);
            if (!"Will reset and reconfigure context ".equals(s2.getMessage())) continue;
            return s2.getTimestamp();
        }
        return -1L;
    }

    public static String diff(Status left2, Status right) {
        StringBuilder sb = new StringBuilder();
        if (left2.getLevel() != right.getLevel()) {
            sb.append(" left.level ").append(left2.getLevel()).append(" != right.level ").append(right.getLevel());
        }
        if (left2.getTimestamp() != right.getTimestamp()) {
            sb.append(" left.timestamp ").append(left2.getTimestamp()).append(" != right.timestamp ").append(right.getTimestamp());
        }
        if (!Objects.equals(left2.getMessage(), right.getMessage())) {
            sb.append(" left.message ").append(left2.getMessage()).append(" != right.message ").append(right.getMessage());
        }
        return sb.toString();
    }
}

