/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.util.CloseUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;

public abstract class ServerSocketListener<T extends Client>
implements ServerListener<T> {
    private final ServerSocket serverSocket;

    public ServerSocketListener(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    @Override
    public T acceptClient() throws IOException {
        Socket socket2 = this.serverSocket.accept();
        return this.createClient(this.socketAddressToString(socket2.getRemoteSocketAddress()), socket2);
    }

    protected abstract T createClient(String var1, Socket var2) throws IOException;

    @Override
    public void close() {
        CloseUtil.closeQuietly(this.serverSocket);
    }

    public String toString() {
        return this.socketAddressToString(this.serverSocket.getLocalSocketAddress());
    }

    private String socketAddressToString(SocketAddress address2) {
        String addr2 = address2.toString();
        int i2 = addr2.indexOf("/");
        if (i2 >= 0) {
            addr2 = addr2.substring(i2 + 1);
        }
        return addr2;
    }
}

