/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.AggregationAssessor;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.PropertySetterException;
import ch.qos.logback.core.util.StringUtil;
import java.lang.reflect.Method;

public class PropertySetter
extends ContextAwareBase {
    protected final Object obj;
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;
    protected final AggregationAssessor aggregationAssessor;

    public PropertySetter(BeanDescriptionCache beanDescriptionCache, Object obj) {
        this.obj = obj;
        this.objClass = obj.getClass();
        this.beanDescription = beanDescriptionCache.getBeanDescription(this.objClass);
        this.aggregationAssessor = new AggregationAssessor(beanDescriptionCache, this.objClass);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.aggregationAssessor.setContext(context);
    }

    public void setProperty(String name2, String value2) {
        if (value2 == null) {
            return;
        }
        Method setter = this.aggregationAssessor.findSetterMethod(name2);
        if (setter == null) {
            this.addWarn("No setter for property [" + name2 + "] in " + this.objClass.getName() + ".");
        } else {
            try {
                this.setProperty(setter, value2);
            }
            catch (PropertySetterException ex) {
                this.addWarn("Failed to set property [" + name2 + "] to value \"" + value2 + "\". ", ex);
            }
        }
    }

    private void setProperty(Method setter, String value2) throws PropertySetterException {
        Object arg2;
        Class<?>[] paramTypes = setter.getParameterTypes();
        try {
            arg2 = StringToObjectConverter.convertArg(this, value2, paramTypes[0]);
        }
        catch (Throwable t) {
            throw new PropertySetterException("Conversion to type [" + String.valueOf(paramTypes[0]) + "] failed. ", t);
        }
        if (arg2 == null) {
            throw new PropertySetterException("Conversion to type [" + String.valueOf(paramTypes[0]) + "] failed.");
        }
        try {
            setter.invoke(this.obj, arg2);
        }
        catch (Exception ex) {
            throw new PropertySetterException(ex);
        }
    }

    public AggregationType computeAggregationType(String name2) {
        return this.aggregationAssessor.computeAggregationType(name2);
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    public void addComplexProperty(String name2, Object complexProperty) {
        Method adderMethod = this.aggregationAssessor.findAdderMethod(name2);
        if (adderMethod != null) {
            Class<?>[] paramTypes = adderMethod.getParameterTypes();
            if (!this.isSanityCheckSuccessful(name2, adderMethod, paramTypes, complexProperty)) {
                return;
            }
            this.invokeMethodWithSingleParameterOnThisObject(adderMethod, complexProperty);
        } else {
            this.addError("Could not find method [add" + name2 + "] in class [" + this.objClass.getName() + "].");
        }
    }

    void invokeMethodWithSingleParameterOnThisObject(Method method2, Object parameter) {
        Class<?> ccc = parameter.getClass();
        try {
            method2.invoke(this.obj, parameter);
        }
        catch (Exception e) {
            this.addError("Could not invoke method " + method2.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + ccc.getName(), e);
        }
    }

    public void addBasicProperty(String name2, String strValue) {
        Object arg2;
        if (strValue == null) {
            return;
        }
        Method adderMethod = this.aggregationAssessor.findAdderMethod(name2 = StringUtil.capitalizeFirstLetter(name2));
        if (adderMethod == null) {
            this.addError("No adder for property [" + name2 + "].");
            return;
        }
        Class<?>[] paramTypes = adderMethod.getParameterTypes();
        this.isSanityCheckSuccessful(name2, adderMethod, paramTypes, strValue);
        try {
            arg2 = StringToObjectConverter.convertArg(this, strValue, paramTypes[0]);
        }
        catch (Throwable t) {
            this.addError("Conversion to type [" + String.valueOf(paramTypes[0]) + "] failed. ", t);
            return;
        }
        if (arg2 != null) {
            this.invokeMethodWithSingleParameterOnThisObject(adderMethod, arg2);
        }
    }

    public void setComplexProperty(String name2, Object complexProperty) {
        Method setter = this.aggregationAssessor.findSetterMethod(name2);
        if (setter == null) {
            this.addWarn("Not setter method for property [" + name2 + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (!this.isSanityCheckSuccessful(name2, setter, paramTypes, complexProperty)) {
            return;
        }
        try {
            this.invokeMethodWithSingleParameterOnThisObject(setter, complexProperty);
        }
        catch (Exception e) {
            this.addError("Could not set component " + String.valueOf(this.obj) + " for parent component " + String.valueOf(this.obj), e);
        }
    }

    private boolean isSanityCheckSuccessful(String name2, Method method2, Class<?>[] params2, Object complexProperty) {
        Class<?> ccc = complexProperty.getClass();
        if (params2.length != 1) {
            this.addError("Wrong number of parameters in setter method for property [" + name2 + "] in " + this.obj.getClass().getName());
            return false;
        }
        if (!params2[0].isAssignableFrom(complexProperty.getClass())) {
            this.addError("A \"" + ccc.getName() + "\" object is not assignable to a \"" + params2[0].getName() + "\" variable.");
            this.addError("The class \"" + params2[0].getName() + "\" was loaded by ");
            this.addError("[" + String.valueOf(params2[0].getClassLoader()) + "] whereas object of type ");
            this.addError("\"" + ccc.getName() + "\" was loaded by [" + String.valueOf(ccc.getClassLoader()) + "].");
            return false;
        }
        return true;
    }

    public Object getObj() {
        return this.obj;
    }

    public Class<?> getClassNameViaImplicitRules(String name2, AggregationType aggregationType, DefaultNestedComponentRegistry registry) {
        return this.aggregationAssessor.getClassNameViaImplicitRules(name2, aggregationType, registry);
    }
}

