/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import java.io.IOException;
import java.io.OutputStream;

public enum ConsoleTarget {
    SystemOut("System.out", new OutputStream(){

        @Override
        public void write(int b2) throws IOException {
            System.out.write(b2);
        }

        @Override
        public void write(byte[] b2) throws IOException {
            System.out.write(b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            System.out.write(b2, off, len);
        }

        @Override
        public void flush() throws IOException {
            System.out.flush();
        }
    }),
    SystemErr("System.err", new OutputStream(){

        @Override
        public void write(int b2) throws IOException {
            System.err.write(b2);
        }

        @Override
        public void write(byte[] b2) throws IOException {
            System.err.write(b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            System.err.write(b2, off, len);
        }

        @Override
        public void flush() throws IOException {
            System.err.flush();
        }
    });

    private final String name;
    private final OutputStream stream;

    public static ConsoleTarget findByName(String name2) {
        for (ConsoleTarget target2 : ConsoleTarget.values()) {
            if (!target2.name.equalsIgnoreCase(name2)) continue;
            return target2;
        }
        return null;
    }

    private ConsoleTarget(String name2, OutputStream stream) {
        this.name = name2;
        this.stream = stream;
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getStream() {
        return this.stream;
    }

    public String toString() {
        return this.name;
    }
}

