/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.LinkedList;
import java.util.List;

public class ThrowableToStringArray {
    public static String[] convert(Throwable t) {
        LinkedList<String> strList = new LinkedList<String>();
        ThrowableToStringArray.extract(strList, t, null);
        return strList.toArray(new String[0]);
    }

    private static void extract(List<String> strList, Throwable t, StackTraceElement[] parentSTE) {
        Throwable cause2;
        StackTraceElement[] ste = t.getStackTrace();
        int numberOfcommonFrames = ThrowableToStringArray.findNumberOfCommonFrames(ste, parentSTE);
        strList.add(ThrowableToStringArray.formatFirstLine(t, parentSTE));
        for (int i2 = 0; i2 < ste.length - numberOfcommonFrames; ++i2) {
            strList.add("\tat " + ste[i2].toString());
        }
        if (numberOfcommonFrames != 0) {
            strList.add("\t... " + numberOfcommonFrames + " common frames omitted");
        }
        if ((cause2 = t.getCause()) != null) {
            ThrowableToStringArray.extract(strList, cause2, ste);
        }
    }

    private static String formatFirstLine(Throwable t, StackTraceElement[] parentSTE) {
        String prefix = "";
        if (parentSTE != null) {
            prefix = "Caused by: ";
        }
        String result2 = prefix + t.getClass().getName();
        if (t.getMessage() != null) {
            result2 = result2 + ": " + t.getMessage();
        }
        return result2;
    }

    private static int findNumberOfCommonFrames(StackTraceElement[] ste, StackTraceElement[] parentSTE) {
        if (parentSTE == null) {
            return 0;
        }
        int steIndex = ste.length - 1;
        int count2 = 0;
        for (int parentIndex = parentSTE.length - 1; steIndex >= 0 && parentIndex >= 0 && ste[steIndex].equals(parentSTE[parentIndex]); --steIndex, --parentIndex) {
            ++count2;
        }
        return count2;
    }
}

