/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.helpers.ThreadLocalMapOfStacks;
import org.slf4j.spi.MDCAdapter;

public class LogbackMDCAdapter
implements MDCAdapter {
    final ThreadLocal<Map<String, String>> readWriteThreadLocalMap = new ThreadLocal();
    final ThreadLocal<Map<String, String>> readOnlyThreadLocalMap = new ThreadLocal();
    private final ThreadLocalMapOfStacks threadLocalMapOfDeques = new ThreadLocalMapOfStacks();

    @Override
    public void put(String key2, String val) throws IllegalArgumentException {
        if (key2 == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> current2 = this.readWriteThreadLocalMap.get();
        if (current2 == null) {
            current2 = new HashMap<String, String>();
            this.readWriteThreadLocalMap.set(current2);
        }
        current2.put(key2, val);
        this.nullifyReadOnlyThreadLocalMap();
    }

    @Override
    public String get(String key2) {
        Map<String, String> hashMap = this.readWriteThreadLocalMap.get();
        if (hashMap != null && key2 != null) {
            return hashMap.get(key2);
        }
        return null;
    }

    @Override
    public void remove(String key2) {
        if (key2 == null) {
            return;
        }
        Map<String, String> current2 = this.readWriteThreadLocalMap.get();
        if (current2 != null) {
            current2.remove(key2);
            this.nullifyReadOnlyThreadLocalMap();
        }
    }

    private void nullifyReadOnlyThreadLocalMap() {
        this.readOnlyThreadLocalMap.set(null);
    }

    @Override
    public void clear() {
        this.readWriteThreadLocalMap.set(null);
        this.nullifyReadOnlyThreadLocalMap();
    }

    public Map<String, String> getPropertyMap() {
        Map<String, String> current2;
        Map<String, String> readOnlyMap = this.readOnlyThreadLocalMap.get();
        if (readOnlyMap == null && (current2 = this.readWriteThreadLocalMap.get()) != null) {
            HashMap<String, String> tempMap = new HashMap<String, String>(current2);
            readOnlyMap = Collections.unmodifiableMap(tempMap);
            this.readOnlyThreadLocalMap.set(readOnlyMap);
        }
        return readOnlyMap;
    }

    public Map getCopyOfContextMap() {
        Map<String, String> readOnlyMap = this.getPropertyMap();
        if (readOnlyMap == null) {
            return null;
        }
        return new HashMap<String, String>(readOnlyMap);
    }

    public Set<String> getKeys() {
        Map<String, String> readOnlyMap = this.getPropertyMap();
        if (readOnlyMap != null) {
            return readOnlyMap.keySet();
        }
        return null;
    }

    public void setContextMap(Map contextMap) {
        if (contextMap != null) {
            this.readWriteThreadLocalMap.set(new HashMap(contextMap));
        } else {
            this.readWriteThreadLocalMap.set(null);
        }
        this.nullifyReadOnlyThreadLocalMap();
    }

    @Override
    public void pushByKey(String key2, String value2) {
        this.threadLocalMapOfDeques.pushByKey(key2, value2);
    }

    @Override
    public String popByKey(String key2) {
        return this.threadLocalMapOfDeques.popByKey(key2);
    }

    @Override
    public Deque<String> getCopyOfDequeByKey(String key2) {
        return this.threadLocalMapOfDeques.getCopyOfDequeByKey(key2);
    }

    @Override
    public void clearDequeByKey(String key2) {
        this.threadLocalMapOfDeques.clearDequeByKey(key2);
    }
}

